/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.endpoint;

import org.springframework.cloud.dataflow.metrics.collector.model.RootResource;
import org.springframework.cloud.dataflow.metrics.collector.model.StreamMetrics;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=RootEndpoint.class)
@RequestMapping(value={"/"})
public class RootEndpoint {
    private final EntityLinks entityLinks;

    public RootEndpoint(EntityLinks entityLinks) {
        this.entityLinks = entityLinks;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/hal+json"})
    public RootResource info() {
        String streamTemplated = this.entityLinks.linkToCollectionResource(StreamMetrics.class).getHref() + "?{name}";
        RootResource rootResource = new RootResource();
        rootResource.add(new Link(streamTemplated).withRel("/collector/metrics/streams"));
        return rootResource;
    }
}

