/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.endpoint;

import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.cloud.dataflow.metrics.collector.model.StreamMetrics;
import org.springframework.cloud.dataflow.metrics.collector.services.ApplicationMetricsService;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collector/metrics/streams"})
@ExposesResourceFor(value=StreamMetrics.class)
public class MetricsCollectorEndpoint {
    private final Pattern pattern = Pattern.compile("integration\\.channel\\.(\\w*)\\.sendCount");
    private ApplicationMetricsService service;

    public MetricsCollectorEndpoint(ApplicationMetricsService service) {
        this.service = service;
    }

    @RequestMapping(produces={"application/hal+json"})
    public ResponseEntity<PagedResources<StreamMetrics>> fetchMetrics(@RequestParam(value="name", defaultValue="") String name) {
        Collection<StreamMetrics> entries = this.service.toStreamMetrics(name);
        int totalPages = entries.size() == 0 ? 0 : entries.size() / entries.size();
        PagedResources.PageMetadata pageMetadata = new PagedResources.PageMetadata((long)entries.size(), 0L, (long)entries.size(), (long)totalPages);
        PagedResources pagedResources = new PagedResources(entries, pageMetadata, new Link[]{ControllerLinkBuilder.linkTo(MetricsCollectorEndpoint.class).withRel("self")});
        return new ResponseEntity((Object)pagedResources, HttpStatus.OK);
    }
}

