/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.metrics.collector.model.ApplicationMetrics;
import org.springframework.cloud.dataflow.metrics.collector.services.ApplicationMetricsService;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class MetricsAggregator {
    private ApplicationMetricsService service;
    private Logger logger = LoggerFactory.getLogger(MetricsAggregator.class);

    public MetricsAggregator(ApplicationMetricsService service) {
        this.service = service;
    }

    @StreamListener(value="input")
    public void receive(ApplicationMetrics metrics) {
        if (metrics.getProperties().get("spring.cloud.application.guid") != null && metrics.getProperties().get("spring.cloud.dataflow.stream.app.label") != null && metrics.getProperties().get("spring.cloud.dataflow.stream.name") != null) {
            this.service.add(metrics);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Metric : {} is missing key properties and will not be consumed by the collector", (Object)metrics.getName());
        }
    }
}

