/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorCreationException;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.BasicDbcpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.HikariCpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.PooledDataSourceCreator;
import org.springframework.cloud.service.relational.TomcatDbcpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.TomcatHighPerformancePooledDataSourceCreator;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public abstract class DataSourceCreator<SI extends RelationalServiceInfo>
extends AbstractServiceConnectorCreator<DataSource, SI> {
    protected static Logger logger = Logger.getLogger(DataSourceCreator.class.getName());
    private String driverSystemPropKey;
    private String[] driverClasses;
    private String validationQuery;
    private List<PooledDataSourceCreator<SI>> pooledDataSourceCreators = new ArrayList<PooledDataSourceCreator<SI>>();

    public DataSourceCreator(String driverSystemPropKey, String[] driverClasses, String validationQuery) {
        this.driverSystemPropKey = driverSystemPropKey;
        this.driverClasses = driverClasses;
        this.validationQuery = validationQuery;
        if (this.pooledDataSourceCreators.size() == 0) {
            this.pooledDataSourceCreators.add(new BasicDbcpPooledDataSourceCreator());
            this.pooledDataSourceCreators.add(new TomcatDbcpPooledDataSourceCreator());
            this.pooledDataSourceCreators.add(new TomcatHighPerformancePooledDataSourceCreator());
            this.pooledDataSourceCreators.add(new HikariCpPooledDataSourceCreator());
        }
    }

    public DataSource create(SI serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        try {
            for (PooledDataSourceCreator<SI> delegate : this.pooledDataSourceCreators) {
                DataSource ds = delegate.create((RelationalServiceInfo)serviceInfo, serviceConnectorConfig, this.getDriverClassName(serviceInfo), this.validationQuery);
                if (ds == null) continue;
                return ds;
            }
            logger.warning("Found neither DBCP nor Tomcat connection pool on the classpath (no pooling is in effect).");
            return new SimpleDriverDataSource(DriverManager.getDriver(serviceInfo.getJdbcUrl()), serviceInfo.getJdbcUrl());
        }
        catch (Exception e) {
            throw new ServiceConnectorCreationException("Failed to created cloud datasource for " + serviceInfo.getId() + " service", (Throwable)e);
        }
    }

    public String getDriverClassName(SI serviceInfo) {
        String userSpecifiedDriver = System.getProperty(this.driverSystemPropKey);
        if (userSpecifiedDriver != null && !userSpecifiedDriver.isEmpty()) {
            return userSpecifiedDriver;
        }
        for (String driver : this.driverClasses) {
            try {
                Class.forName(driver);
                return driver;
            }
            catch (ClassNotFoundException ex) {
            }
        }
        throw new CloudException("No suitable database driver found for " + serviceInfo.getId() + " service ");
    }
}

