/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.config.xml.AbstractPoolingCloudServiceFactoryParser;
import org.springframework.cloud.service.relational.CloudDataSourceFactory;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CloudDataSourceFactoryParser
extends AbstractPoolingCloudServiceFactoryParser {
    private static final String ELEMENT_CONNECTION = "connection";
    private static final String ELEMENT_POOL = "pool";

    public CloudDataSourceFactoryParser() {
        super(CloudDataSourceFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinition cloudConnectionConfiguration = null;
        Element connectionElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_CONNECTION);
        if (connectionElement != null) {
            cloudConnectionConfiguration = this.parseConnectionElement(connectionElement);
        }
        BeanDefinition cloudPoolConfiguration = null;
        Element poolElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_POOL);
        if (poolElement != null) {
            cloudPoolConfiguration = this.parsePoolElement(poolElement, parserContext);
        }
        BeanDefinitionBuilder dataSourceConfigBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.cloud.service.relational.DataSourceConfig");
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)cloudPoolConfiguration);
        dataSourceConfigBeanBuilder.addConstructorArgValue((Object)cloudConnectionConfiguration);
        builder.addConstructorArgValue((Object)dataSourceConfigBeanBuilder.getBeanDefinition());
    }

    private BeanDefinition parseConnectionElement(Element element) {
        BeanDefinitionBuilder cloudConnectionConfigurationBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.cloud.service.relational.DataSourceConfig.ConnectionConfig");
        String connectionProperties = element.getAttribute("properties");
        if (StringUtils.hasText((String)connectionProperties)) {
            cloudConnectionConfigurationBeanBuilder.addConstructorArgValue((Object)connectionProperties);
        }
        return cloudConnectionConfigurationBeanBuilder.getBeanDefinition();
    }
}

