/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.DbcpLikePooledDataSourceCreator;

public class BasicDbcpPooledDataSourceCreator<SI extends RelationalServiceInfo>
extends DbcpLikePooledDataSourceCreator<SI> {
    @Override
    public DataSource create(RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        if (Util.hasClass("org.apache.commons.dbcp2.BasicDataSource")) {
            logger.info("Found DBCP2 on the classpath. Using it for DataSource connection pooling.");
            org.apache.commons.dbcp2.BasicDataSource ds = new org.apache.commons.dbcp2.BasicDataSource();
            this.setBasicDataSourceProperties((DataSource)ds, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return ds;
        }
        if (Util.hasClass("org.apache.commons.dbcp.BasicDataSource")) {
            logger.info("Found DBCP on the classpath. Using it for DataSource connection pooling.");
            BasicDataSource ds = new BasicDataSource();
            this.setBasicDataSourceProperties((DataSource)ds, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return ds;
        }
        return null;
    }
}

