/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.BasicDataSource;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.DbcpLikePooledDataSourceCreator;

public class TomcatDbcpPooledDataSourceCreator<SI extends RelationalServiceInfo>
extends DbcpLikePooledDataSourceCreator<SI> {
    @Override
    public DataSource create(RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        if (Util.hasClass("org.apache.tomcat.dbcp.dbcp.BasicDataSource")) {
            logger.info("Found Tomcat dbcp connection pool on the classpath. Using it for DataSource connection pooling.");
            BasicDataSource ds = new BasicDataSource();
            this.setBasicDataSourceProperties((DataSource)ds, serviceInfo, serviceConnectorConfig, driverClassName, validationQuery);
            return ds;
        }
        return null;
    }
}

