/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.keyval;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfigurer;
import org.springframework.cloud.service.Util;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConnectionFactoryConfigurer
implements ServiceConnectorConfigurer<JedisConnectionFactory, PooledServiceConnectorConfig> {
    public JedisConnectionFactory configure(JedisConnectionFactory connectionFactory, PooledServiceConnectorConfig config) {
        if (config != null && config.getPoolConfig() != null) {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
            BeanWrapperImpl source = new BeanWrapperImpl((Object)config.getPoolConfig());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            connectionFactory.setPoolConfig(poolConfig);
        }
        return connectionFactory;
    }
}

