/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config;

import java.util.List;
import java.util.logging.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.GenericCloudServiceConnectorFactory;
import org.springframework.cloud.service.ServiceInfo;

public class ServiceScanHelper {
    private static final String CLOUD_FACTORY_BEAN_NAME = "__cloud_factory__";
    private static Logger logger = Logger.getLogger(ServiceScanHelper.class.getName());
    private Cloud cloud;

    public void registerServiceBeans(BeanDefinitionRegistry registry) {
        this.initializeCloud(registry);
        List serviceInfos = this.cloud.getServiceInfos();
        for (ServiceInfo serviceInfo : serviceInfos) {
            this.registerServiceBean(registry, serviceInfo);
        }
    }

    private void initializeCloud(BeanDefinitionRegistry registry) {
        if (this.cloud != null) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
        if (beanFactory.getBeansOfType(CloudFactory.class).isEmpty()) {
            beanFactory.registerSingleton(CLOUD_FACTORY_BEAN_NAME, (Object)new CloudFactory());
        }
        CloudFactory cloudFactory = (CloudFactory)beanFactory.getBeansOfType(CloudFactory.class).values().iterator().next();
        this.cloud = cloudFactory.getCloud();
    }

    private void registerServiceBean(BeanDefinitionRegistry registry, ServiceInfo serviceInfo) {
        try {
            GenericCloudServiceConnectorFactory serviceFactory = new GenericCloudServiceConnectorFactory(serviceInfo.getId(), null);
            serviceFactory.setBeanFactory((BeanFactory)registry);
            serviceFactory.afterPropertiesSet();
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ScannedServiceWrapper.class);
            definitionBuilder.addConstructorArgValue((Object)serviceFactory);
            definitionBuilder.getRawBeanDefinition().setAttribute("factoryBeanObjectType", serviceFactory.getObjectType());
            registry.registerBeanDefinition(serviceInfo.getId(), (BeanDefinition)definitionBuilder.getBeanDefinition());
        }
        catch (Exception ex) {
            logger.warning("Unable to create service for " + serviceInfo.getId() + " during service scanning. Skiping.");
        }
    }

    public static class ScannedServiceWrapper
    implements FactoryBean<Object> {
        private GenericCloudServiceConnectorFactory cloudServiceConnectorFactory;

        public ScannedServiceWrapper(GenericCloudServiceConnectorFactory cloudServiceConnectorFactory) {
            this.cloudServiceConnectorFactory = cloudServiceConnectorFactory;
        }

        public Object getObject() throws Exception {
            return this.cloudServiceConnectorFactory.getObject();
        }

        public Class<?> getObjectType() {
            return this.cloudServiceConnectorFactory.getObjectType();
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

