/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.test;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanBuilder;
import org.springframework.lang.Nullable;

public class TestTracer
implements Tracer,
AutoCloseable {
    private final Tracer delegate;
    final Queue<Span> createdSpans = new LinkedList<Span>();

    public TestTracer(Tracer delegate) {
        this.delegate = delegate;
    }

    public Map<String, String> getAllBaggage() {
        return this.delegate.getAllBaggage();
    }

    public BaggageInScope getBaggage(String name) {
        return this.delegate.getBaggage(name);
    }

    public BaggageInScope getBaggage(TraceContext traceContext, String name) {
        return this.delegate.getBaggage(traceContext, name);
    }

    public BaggageInScope createBaggage(String name) {
        return this.delegate.createBaggage(name);
    }

    public BaggageInScope createBaggage(String name, String value) {
        return this.delegate.createBaggage(name, value);
    }

    public Span nextSpan() {
        Span span = this.delegate.nextSpan();
        this.createdSpans.add(span);
        return span;
    }

    public Span nextSpan(Span parent) {
        Span span = this.delegate.nextSpan(parent);
        this.createdSpans.add(span);
        return span;
    }

    public Tracer.SpanInScope withSpan(Span span) {
        return this.delegate.withSpan(span);
    }

    public ScopedSpan startScopedSpan(String name) {
        return this.delegate.startScopedSpan(name);
    }

    public Span.Builder spanBuilder() {
        return new TestSpanBuilder(this.delegate.spanBuilder(), this);
    }

    public TraceContext.Builder traceContextBuilder() {
        return this.delegate.traceContextBuilder();
    }

    @Nullable
    public SpanCustomizer currentSpanCustomizer() {
        return this.delegate.currentSpanCustomizer();
    }

    @Nullable
    public Span currentSpan() {
        return this.delegate.currentSpan();
    }

    @Override
    public void close() throws Exception {
        this.createdSpans.clear();
    }

    public Queue<Span> createdSpans() {
        return this.createdSpans;
    }

    public CurrentTraceContext currentTraceContext() {
        return this.delegate.currentTraceContext();
    }
}

