/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.r2dbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveContinuedTransactionService;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveCustomer;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveCustomerRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class ReactiveNewTransactionService {
    private static final Logger log = LoggerFactory.getLogger(ReactiveNewTransactionService.class);
    private final ReactiveCustomerRepository repository;
    private final ReactiveContinuedTransactionService reactiveContinuedTransactionService;

    public ReactiveNewTransactionService(ReactiveCustomerRepository repository, ReactiveContinuedTransactionService reactiveContinuedTransactionService) {
        this.repository = repository;
        this.reactiveContinuedTransactionService = reactiveContinuedTransactionService;
    }

    @Transactional
    public Mono<Void> newTransaction() {
        return Mono.fromRunnable(() -> log.info("Hello from new transaction")).then(this.repository.save(new ReactiveCustomer("Jack", "Bauer"))).then(this.repository.save(new ReactiveCustomer("Chloe", "O'Brian"))).then(this.repository.save(new ReactiveCustomer("Kim", "Bauer"))).then(this.repository.save(new ReactiveCustomer("David", "Palmer"))).then(this.repository.save(new ReactiveCustomer("Michelle", "Dessler"))).doOnNext(reactiveCustomer -> {
            log.info("Customers found with findAll():");
            log.info("-------------------------------");
        }).flatMapMany(reactiveCustomer -> this.repository.findAll()).doOnNext(cust -> log.info(cust.toString())).doOnNext(o -> log.info("")).then(this.reactiveContinuedTransactionService.continuedTransaction());
    }
}

