/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave;

import brave.Span;
import brave.test.IntegrationTestSpanHandler;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.brave.bridge.BraveAccessor;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;

public class BraveTestSpanHandler
implements TestSpanHandler {
    final brave.test.TestSpanHandler spans;
    final IntegrationTestSpanHandler integrationSpans;

    public BraveTestSpanHandler(brave.test.TestSpanHandler spans) {
        this.spans = spans;
        this.integrationSpans = null;
    }

    public BraveTestSpanHandler(IntegrationTestSpanHandler integrationSpans) {
        this.spans = null;
        this.integrationSpans = integrationSpans;
    }

    public BraveTestSpanHandler(brave.test.TestSpanHandler spans, IntegrationTestSpanHandler integrationSpans) {
        this.spans = spans;
        this.integrationSpans = integrationSpans;
    }

    @Override
    public List<FinishedSpan> reportedSpans() {
        return this.spans.spans().stream().map(BraveAccessor::finishedSpan).collect(Collectors.toList());
    }

    @Override
    public FinishedSpan takeLocalSpan() {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeLocalSpan());
    }

    @Override
    public void clear() {
        if (this.spans != null) {
            this.spans.clear();
        }
    }

    @Override
    public FinishedSpan takeRemoteSpan(Span.Kind kind) {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeRemoteSpan(Span.Kind.valueOf((String)kind.name())));
    }

    @Override
    public FinishedSpan takeRemoteSpanWithError(Span.Kind kind) {
        return BraveAccessor.finishedSpan(this.integrationSpans.takeRemoteSpanWithError(Span.Kind.valueOf((String)kind.name())));
    }

    @Override
    public FinishedSpan get(int index) {
        return BraveAccessor.finishedSpan(this.spans.get(index));
    }

    @Override
    public Iterator<FinishedSpan> iterator() {
        return this.reportedSpans().iterator();
    }

    public String toString() {
        return "BraveTestSpanHandler{spans=" + this.spans + ", integrationSpans=" + this.integrationSpans + '}';
    }
}

