/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.instrument.web.servlet.TracingFilter;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.cloud.sleuth.test.TracerAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public abstract class TraceFilterTests
implements TestTracingAwareSupplier {
    protected Tracer tracer = this.tracerTest().tracing().tracer();
    protected CurrentTraceContext currentTraceContext = this.tracerTest().tracing().currentTraceContext();
    protected Filter filter = TracingFilter.create((CurrentTraceContext)this.currentTraceContext, (HttpServerHandler)this.tracerTest().tracing().httpServerHandler());
    protected TestSpanHandler spans = this.tracerTest().handler();
    protected MockHttpServletRequest request;
    protected MockHttpServletResponse response;
    protected MockFilterChain filterChain;

    @BeforeEach
    public void init() {
        this.request = this.builder().buildRequest((ServletContext)new MockServletContext());
        this.response = new MockHttpServletResponse();
        this.response.setContentType("application/json");
        this.filterChain = new MockFilterChain();
    }

    public MockHttpServletRequestBuilder builder() {
        return MockMvcRequestBuilders.get((String)"/?foo=bar", (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("User-Agent", new Object[]{"MockMvc"});
    }

    @AfterEach
    public void cleanup() {
        this.tracerTest().close();
    }

    @Test
    public void notTraced() throws Exception {
        this.request = MockMvcRequestBuilders.get((String)"/favicon.ico", (Object[])new Object[0]).accept(new MediaType[]{MediaType.ALL}).buildRequest((ServletContext)new MockServletContext());
        this.neverSampleFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
    }

    protected Filter neverSampleFilter() {
        return TracingFilter.create((CurrentTraceContext)this.tracerTest().tracing().currentTraceContext(), (HttpServerHandler)this.tracerTest().tracing().sampler(TracerAware.TraceSampler.OFF).httpServerHandler());
    }

    @Test
    public void startsNewTrace() throws Exception {
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"http.path", (Object)"/")).containsEntry((Object)"http.method", (Object)HttpMethod.GET.toString());
        BDDAssertions.then((String)this.spans.get(0).getRemoteIp()).isEqualTo("127.0.0.1");
    }

    @Test
    public void continuesATraceWhenSpanNotSampled() throws Exception {
        AtomicReference span = new AtomicReference();
        this.request = this.builder().header("b3", new Object[]{"0000000000000014-000000000000000a-0"}).buildRequest((ServletContext)new MockServletContext());
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (req, resp) -> {
            this.filterChain.doFilter(req, resp);
            span.set(this.tracerTest().tracing().tracer().currentSpan());
        });
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((String)((Span)span.get()).context().traceId()).isEqualTo(this.tracerTest().assertions().or128Bit("0000000000000014"));
    }

    @Test
    public void continuesSpanInRequestAttr() throws Exception {
        Span span = this.tracer.nextSpan().name("http:foo");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void closesSpanInRequestAttrIfStatusCodeNotSuccessful() throws Exception {
        Span span = this.tracer.nextSpan().name("http:foo");
        this.response.setStatus(404);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @Test
    public void doesntDetachASpanIfStatusCodeNotSuccessfulAndRequestWasProcessed() throws Exception {
        Span span = this.tracer.nextSpan().name("http:foo");
        this.response.setStatus(404);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
    }

    @Test
    public void continuesSpanFromHeaders() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"0000000000000014-000000000000000a"}).buildRequest((ServletContext)new MockServletContext());
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        this.verifyParentSpanHttpTags();
    }

    public abstract HttpServerHandler httpServerHandler();

    @Test
    public void shouldAnnotateSpanWithErrorWhenExceptionIsThrown() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"0000000000000014-000000000000000a"}).buildRequest((ServletContext)new MockServletContext());
        this.filterChain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                throw new RuntimeException("Planned");
            }
        };
        try {
            this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Planned");
        }
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        this.verifyParentSpanHttpTags();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("Planned");
    }

    @Test
    public void detachesSpanWhenResponseStatusIsNot2xx() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"14-a"}).buildRequest((ServletContext)new MockServletContext());
        this.response.setStatus(404);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
    }

    @Test
    public void closesSpanWhenResponseStatusIs2xx() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"0000000000000014-000000000000000a"}).buildRequest((ServletContext)new MockServletContext());
        this.response.setStatus(200);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @Test
    public void closesSpanWhenResponseStatusIs3xx() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"0000000000000014-000000000000000a"}).buildRequest((ServletContext)new MockServletContext());
        this.response.setStatus(302);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @Test
    public void returns400IfSpanIsMalformedAndCreatesANewSpan() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"asd"}).buildRequest((ServletContext)new MockServletContext());
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
        BDDAssertions.then((int)this.response.getStatus()).isEqualTo(HttpStatus.OK.value());
    }

    @Test
    public void returns200IfSpanParentIsMalformedAndCreatesANewSpan() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"asd"}).buildRequest((ServletContext)new MockServletContext());
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
        BDDAssertions.then((int)this.response.getStatus()).isEqualTo(HttpStatus.OK.value());
    }

    @Test
    public void usesSamplingMechanismWhenIncomingTraceIsMalformed() throws Exception {
        this.request = this.builder().header("b3", new Object[]{"asd"}).buildRequest((ServletContext)new MockServletContext());
        this.neverSampleFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracerTest().tracing().tracer().currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.tracerTest().handler()).isEmpty();
    }

    @Test
    public void shouldSetTraceKeysForAnUntracedRequest() throws Exception {
        this.request = this.builder().param("foo", new String[]{"bar"}).buildRequest((ServletContext)new MockServletContext());
        this.response.setStatus(295);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, (FilterChain)this.filterChain);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"http.path", (Object)"/")).containsEntry((Object)"http.method", (Object)HttpMethod.GET.toString());
    }

    public void verifyParentSpanHttpTags() {
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
        ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"http.path", (Object)"/")).containsEntry((Object)"http.method", (Object)HttpMethod.GET.toString());
    }
}

