/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.BaggageManager;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.CompositeBaggage;
import org.springframework.cloud.sleuth.otel.bridge.Entry;
import org.springframework.cloud.sleuth.otel.bridge.OtelBaggageInScope;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;

public class OtelBaggageManager
implements BaggageManager {
    private static final String PROPAGATION_UNLIMITED = "propagation=unlimited";
    private final CurrentTraceContext currentTraceContext;
    private final List<String> remoteFields;
    private final List<String> tagFields;
    private final ApplicationEventPublisher publisher;

    public OtelBaggageManager(CurrentTraceContext currentTraceContext, List<String> remoteFields, List<String> tagFields, ApplicationEventPublisher publisher) {
        this.currentTraceContext = currentTraceContext;
        this.remoteFields = remoteFields;
        this.tagFields = tagFields;
        this.publisher = publisher;
    }

    public Map<String, String> getAllBaggage() {
        HashMap<String, String> baggage = new HashMap<String, String>();
        this.currentBaggage().getEntries().forEach(entry -> baggage.put(entry.getKey(), entry.getValue()));
        return baggage;
    }

    CompositeBaggage currentBaggage() {
        OtelTraceContext traceContext = (OtelTraceContext)this.currentTraceContext.context();
        Context context = Context.current();
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        if (traceContext != null) {
            stack.addFirst(traceContext.context());
        }
        stack.addFirst(context);
        return new CompositeBaggage(stack);
    }

    public BaggageInScope getBaggage(String name) {
        Entry entry = this.getBaggage(name, this.currentBaggage());
        return this.createNewEntryIfMissing(name, entry);
    }

    BaggageInScope createNewEntryIfMissing(String name, Entry entry) {
        if (entry == null) {
            return this.createBaggage(name);
        }
        return this.otelBaggage(entry);
    }

    private Entry getBaggage(String name, Baggage baggage) {
        return this.entryForName(name, baggage);
    }

    public BaggageInScope getBaggage(TraceContext traceContext, String name) {
        OtelTraceContext context = (OtelTraceContext)traceContext;
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        Context current = Context.current();
        Context traceContextContext = context.context();
        stack.addFirst(current);
        if (current != traceContextContext) {
            stack.addFirst(traceContextContext);
        }
        Context ctx = this.removeFirst(stack);
        Entry entry = null;
        while (ctx != null && entry == null) {
            entry = this.getBaggage(name, Baggage.fromContext((Context)ctx));
            ctx = this.removeFirst(stack);
        }
        if (entry != null) {
            return this.otelBaggage(entry);
        }
        return null;
    }

    Entry getEntry(OtelTraceContext traceContext, String name) {
        OtelTraceContext context = traceContext;
        Context ctx = context.context();
        return this.getBaggage(name, Baggage.fromContext((Context)ctx));
    }

    Context removeFirst(Deque<Context> stack) {
        return stack.isEmpty() ? null : stack.removeFirst();
    }

    private Entry entryForName(String name, Baggage baggage) {
        return Entry.fromBaggage(baggage).stream().filter(e -> e.getKey().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private BaggageInScope otelBaggage(Entry entry) {
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    public BaggageInScope createBaggage(String name) {
        return this.createBaggage(name, null);
    }

    public BaggageInScope createBaggage(String name, String value) {
        BaggageInScope baggage = this.baggageWithValue(name, value);
        return baggage.set(value);
    }

    private BaggageInScope baggageWithValue(String name, @Nullable String value) {
        boolean remoteField = this.remoteFields.stream().map(String::toLowerCase).anyMatch(s -> s.equals(name.toLowerCase()));
        BaggageEntryMetadata entryMetadata = BaggageEntryMetadata.create((String)this.propagationString(remoteField));
        Entry entry = new Entry(name, value, entryMetadata);
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    private String propagationString(boolean remoteField) {
        String propagation = "";
        if (remoteField) {
            propagation = PROPAGATION_UNLIMITED;
        }
        return propagation;
    }
}

