/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.context.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.otel.bridge.Entry;

class CompositeBaggage
implements Baggage {
    private final Collection<Entry> entries;
    private final Map<String, BaggageEntry> baggageEntries;

    CompositeBaggage(Deque<Context> stack) {
        this.entries = Collections.unmodifiableCollection(this.createEntries(stack));
        this.baggageEntries = Collections.unmodifiableMap(this.entries.stream().collect(Collectors.toMap(Entry::getKey, Function.identity())));
    }

    private Collection<Entry> createEntries(Deque<Context> stack) {
        HashMap map = new HashMap();
        Iterator<Context> iterator = stack.descendingIterator();
        while (iterator.hasNext()) {
            Context next = iterator.next();
            Baggage baggage = Baggage.fromContext((Context)next);
            baggage.forEach((key, value) -> map.put(key, new Entry((String)key, value.getValue(), value.getMetadata())));
        }
        return map.values();
    }

    Collection<Entry> getEntries() {
        return this.entries;
    }

    public int size() {
        return this.entries.size();
    }

    public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
        this.entries.forEach((? super T entry) -> consumer.accept(entry.getKey(), (BaggageEntry)entry));
    }

    public Map<String, BaggageEntry> asMap() {
        return this.baggageEntries;
    }

    public String getEntryValue(String entryKey) {
        return this.entries.stream().filter(entry -> entryKey.equals(entry.getKey())).map(Entry::getValue).findFirst().orElse(null);
    }

    public BaggageBuilder toBuilder() {
        return Baggage.builder();
    }
}

