/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.otel.bridge.EventPublishingContextWrapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class Slf4jBaggageApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Log log = LogFactory.getLog(Slf4jBaggageApplicationListener.class);
    private final List<String> lowerCaseCorrelationFields;
    private final List<String> correlationFields;

    public Slf4jBaggageApplicationListener(List<String> correlationFields) {
        this.lowerCaseCorrelationFields = correlationFields.stream().map(String::toLowerCase).collect(Collectors.toList());
        this.correlationFields = correlationFields;
    }

    private void onScopeAttached(EventPublishingContextWrapper.ScopeAttachedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope attached event [" + (Object)((Object)event) + "]"));
        }
        if (event.getBaggage() != null) {
            this.putEntriesIntoMdc(event.getBaggage());
        }
    }

    private void onScopeRestored(EventPublishingContextWrapper.ScopeRestoredEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope restored event [" + (Object)((Object)event) + "]"));
        }
        if (event.getBaggage() != null) {
            this.putEntriesIntoMdc(event.getBaggage());
        }
    }

    private void putEntriesIntoMdc(Baggage baggage) {
        baggage.forEach((key, baggageEntry) -> {
            if (this.lowerCaseCorrelationFields.contains(key.toLowerCase())) {
                MDC.put((String)key, (String)baggageEntry.getValue());
            }
        });
    }

    private void onScopeClosed(EventPublishingContextWrapper.ScopeClosedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope closed event [" + (Object)((Object)event) + "]"));
        }
        this.correlationFields.forEach(MDC::remove);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof EventPublishingContextWrapper.ScopeAttachedEvent) {
            this.onScopeAttached((EventPublishingContextWrapper.ScopeAttachedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeClosedEvent) {
            this.onScopeClosed((EventPublishingContextWrapper.ScopeClosedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeRestoredEvent) {
            this.onScopeRestored((EventPublishingContextWrapper.ScopeRestoredEvent)event);
        }
    }
}

