/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.context.Context;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.SpanFromSpanContext;

class OtelSpan
implements Span {
    final io.opentelemetry.api.trace.Span delegate;
    private final AtomicReference<Context> context;

    OtelSpan(io.opentelemetry.api.trace.Span delegate) {
        this.delegate = delegate;
        if (delegate instanceof SpanFromSpanContext) {
            SpanFromSpanContext fromSpanContext = (SpanFromSpanContext)delegate;
            this.context = fromSpanContext.otelTraceContext.context;
        } else {
            this.context = new AtomicReference<Context>(Context.current());
        }
    }

    OtelSpan(io.opentelemetry.api.trace.Span delegate, Context context) {
        this.delegate = delegate;
        this.context = new AtomicReference<Context>(context);
    }

    static io.opentelemetry.api.trace.Span toOtel(Span span) {
        return ((OtelSpan)span).delegate;
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span) {
        return new OtelSpan(span);
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span, Context context) {
        return new OtelSpan(span, context);
    }

    public boolean isNoop() {
        return !this.delegate.isRecording();
    }

    public TraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return new OtelTraceContext(this.context, this.delegate.getSpanContext(), this.delegate);
    }

    public Span start() {
        return this;
    }

    public Span name(String name) {
        this.delegate.updateName(name);
        return new OtelSpan(this.delegate);
    }

    public Span event(String value) {
        this.delegate.addEvent(value);
        return new OtelSpan(this.delegate);
    }

    public Span tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return new OtelSpan(this.delegate);
    }

    public Span error(Throwable throwable) {
        this.delegate.recordException(throwable);
        return new OtelSpan(this.delegate);
    }

    public void end() {
        this.delegate.end();
    }

    public void abandon() {
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute("peer.service", remoteServiceName);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtelSpan otelSpan = (OtelSpan)o;
        return Objects.equals(this.delegate, otelSpan.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

