/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.tracer.HttpServerTracer;
import java.net.URI;
import java.util.regex.Pattern;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.util.StringUtils;

public class OtelHttpServerHandler
extends HttpServerTracer<HttpServerRequest, HttpServerResponse, HttpServerRequest, HttpServerRequest>
implements HttpServerHandler {
    private final HttpRequestParser httpServerRequestParser;
    private final HttpResponseParser httpServerResponseParser;
    private final Pattern pattern;

    public OtelHttpServerHandler(OpenTelemetry openTelemetry, HttpRequestParser httpServerRequestParser, HttpResponseParser httpServerResponseParser, SkipPatternProvider skipPatternProvider) {
        super(openTelemetry);
        this.httpServerRequestParser = httpServerRequestParser;
        this.httpServerResponseParser = httpServerResponseParser;
        this.pattern = skipPatternProvider.skipPattern();
    }

    public Span handleReceive(HttpServerRequest request) {
        boolean shouldSkip;
        String url = request.path();
        boolean bl = shouldSkip = !StringUtils.isEmpty((Object)url) && this.pattern.matcher(url).matches();
        if (shouldSkip) {
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        Context context = this.startSpan(request, request, request, request.method());
        return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.fromContext((Context)context), context);
    }

    public void handleSend(HttpServerResponse response, Span span) {
        Throwable throwable = response.error();
        io.opentelemetry.api.trace.Span otel = OtelSpan.toOtel(span);
        try (Scope scope = otel.makeCurrent();){
            this.parseResponse(span, response);
            if (throwable == null) {
                this.end(Context.current(), response);
            } else {
                this.endExceptionally(Context.current(), throwable, response);
            }
        }
    }

    private void parseResponse(Span span, HttpServerResponse response) {
        if (this.httpServerResponseParser != null) {
            this.httpServerResponseParser.parse((HttpResponse)response, span.context(), (SpanCustomizer)span);
        }
    }

    public Context startSpan(HttpServerRequest connection, HttpServerRequest request, HttpServerRequest storage, String spanName, long startTimestamp) {
        Context context = super.startSpan((Object)connection, (Object)request, (Object)storage, spanName, startTimestamp);
        if (this.httpServerRequestParser != null) {
            io.opentelemetry.api.trace.Span otelSpan = io.opentelemetry.api.trace.Span.fromContext((Context)context);
            Span fromOtel = OtelSpan.fromOtel(otelSpan);
            this.httpServerRequestParser.parse((HttpRequest)connection, fromOtel.context(), (SpanCustomizer)fromOtel);
        }
        return context;
    }

    protected void onRequest(SpanBuilder spanBuilder, HttpServerRequest request) {
        super.onRequest(spanBuilder, (Object)request);
        String path = request.path();
        if (StringUtils.hasText((String)path)) {
            spanBuilder.setAttribute("http.path", path);
        }
    }

    public Context getServerContext(HttpServerRequest request) {
        Object context = request.getAttribute(CONTEXT_ATTRIBUTE);
        return context instanceof Context ? (Context)context : null;
    }

    protected Integer peerPort(HttpServerRequest request) {
        return this.toUri(request).getPort();
    }

    protected String peerHostIp(HttpServerRequest request) {
        return this.toUri(request).getHost();
    }

    protected String flavor(HttpServerRequest request, HttpServerRequest request2) {
        return this.toUri(request).getScheme();
    }

    protected TextMapGetter<HttpServerRequest> getGetter() {
        return new TextMapGetter<HttpServerRequest>(){

            public Iterable<String> keys(HttpServerRequest carrier) {
                return carrier.headerNames();
            }

            public String get(HttpServerRequest carrier, String key) {
                return carrier.header(key);
            }
        };
    }

    protected String url(HttpServerRequest request) {
        return request.url();
    }

    protected String scheme(HttpServerRequest request) {
        return this.toUri(request).getScheme();
    }

    protected String host(HttpServerRequest request) {
        return this.toUri(request).getHost();
    }

    protected String target(HttpServerRequest request) {
        URI uri = this.toUri(request);
        return uri.getPath() + this.queryPart(uri) + this.fragmentPart(uri);
    }

    private String queryPart(URI uri) {
        String query = uri.getQuery();
        return query != null ? "?" + query : "";
    }

    private String fragmentPart(URI uri) {
        String fragment = uri.getFragment();
        return fragment != null ? "#" + fragment : "";
    }

    protected URI toUri(HttpServerRequest request) {
        return URI.create(request.url());
    }

    protected String method(HttpServerRequest request) {
        return request.method();
    }

    protected String requestHeader(HttpServerRequest request, String s) {
        return request.header(s);
    }

    protected int responseStatus(HttpServerResponse httpServerResponse) {
        return httpServerResponse.statusCode();
    }

    protected void attachServerContext(Context context, HttpServerRequest request) {
        request.setAttribute(CONTEXT_ATTRIBUTE, (Object)context);
    }

    protected String getInstrumentationName() {
        return "org.springframework.cloud.sleuth";
    }
}

