/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.otel.bridge.OtelFinishedSpan;

public class CompositeSpanExporter
implements SpanExporter {
    private final SpanExporter delegate;
    private final List<SpanFilter> filters;

    public CompositeSpanExporter(SpanExporter delegate, List<SpanFilter> filters) {
        this.delegate = delegate;
        this.filters = filters;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.delegate.export((Collection)spans.stream().filter(this::shouldProcess).collect(Collectors.toList()));
    }

    private boolean shouldProcess(SpanData span) {
        for (SpanFilter filter : this.filters) {
            if (filter.isExportable(OtelFinishedSpan.fromOtel(span))) continue;
            return false;
        }
        return true;
    }

    public CompletableResultCode flush() {
        return this.delegate.flush();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

