/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.sdk.extension.resources.OsResource;
import io.opentelemetry.sdk.extension.resources.ProcessResource;
import io.opentelemetry.sdk.extension.resources.ProcessRuntimeResource;
import io.opentelemetry.sdk.resources.Resource;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelResourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ProcessResource.class})
@EnableConfigurationProperties(value={OtelResourceProperties.class})
@ConditionalOnProperty(value={"spring.sleuth.otel.resource.enabled"}, matchIfMissing=true)
class OtelResourceConfiguration {
    OtelResourceConfiguration() {
    }

    @Bean
    Supplier<Resource> otelOsResourceProvider() {
        return OsResource::get;
    }

    @Bean
    Supplier<Resource> otelProcessResourceProvider() {
        return ProcessResource::get;
    }

    @Bean
    Supplier<Resource> otelProcessRuntimeResourceProvider() {
        return ProcessRuntimeResource::get;
    }
}

