/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelExporterProperties;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.otel.bridge.CompositeSpanExporter;
import org.springframework.cloud.sleuth.otel.bridge.SpanExporterCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpanExporter.class})
@EnableConfigurationProperties(value={OtelExporterProperties.class})
class OtelExporterConfiguration {
    OtelExporterConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.otel.exporter.sleuth-span-filter.enabled"}, matchIfMissing=true)
    SpanExporterCustomizer sleuthSpanFilterConverter(final List<SpanFilter> spanFilters) {
        return new SpanExporterCustomizer(){

            public SpanExporter customize(SpanExporter spanExporter) {
                return new CompositeSpanExporter(spanExporter, spanFilters);
            }
        };
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OtlpGrpcSpanExporter.class})
    static class OtlpExporterConfiguration {
        OtlpExporterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        OtlpGrpcSpanExporter otelOtlpGrpcSpanExporter(OtelExporterProperties properties) {
            Map<String, String> headers;
            Long timeout;
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            String endpoint = properties.getOtlp().getEndpoint();
            if (StringUtils.hasText((String)endpoint)) {
                builder.setEndpoint(endpoint);
            }
            if ((timeout = properties.getOtlp().getTimeout()) != null) {
                builder.setTimeout(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
            if (!(headers = properties.getOtlp().getHeaders()).isEmpty()) {
                headers.forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
            }
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JaegerGrpcSpanExporter.class})
    static class JaegerExporterConfiguration {
        JaegerExporterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JaegerGrpcSpanExporter otelJaegerGrpcSpanExporter(OtelExporterProperties properties) {
            Long timeout;
            JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
            String endpoint = properties.getJaeger().getEndpoint();
            if (StringUtils.hasText((String)endpoint)) {
                builder.setEndpoint(endpoint);
            }
            if ((timeout = properties.getJaeger().getTimeout()) != null) {
                builder.setTimeout(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
            return builder.build();
        }
    }
}

