/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.lang.Nullable;

final class TracingFeignClient
implements Client {
    private static final Log log = LogFactory.getLog(TracingFeignClient.class);
    final CurrentTraceContext currentTraceContext;
    final Client delegate;
    final HttpClientHandler handler;

    TracingFeignClient(CurrentTraceContext currentTraceContext, HttpClientHandler handler, Client delegate) {
        this.currentTraceContext = currentTraceContext;
        this.handler = handler;
        Client delegateTarget = (Client)ProxyUtils.getTargetObject((Object)delegate);
        this.delegate = delegateTarget instanceof TracingFeignClient ? ((TracingFeignClient)delegateTarget).delegate : delegateTarget;
    }

    static Client create(CurrentTraceContext currentTraceContext, HttpClientHandler handler, Client delegate) {
        return new TracingFeignClient(currentTraceContext, handler, delegate);
    }

    /*
     * Loose catch block
     */
    public Response execute(Request req, Request.Options options) throws IOException {
        Response response;
        CurrentTraceContext.Scope ws;
        Throwable error;
        Response res;
        Span span;
        RequestWrapper request;
        block14: {
            request = new RequestWrapper(req);
            span = this.handler.handleSend((HttpClientRequest)request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handled send of " + span));
            }
            res = null;
            error = null;
            ws = this.currentTraceContext.newScope(span.context());
            res = this.delegate.execute(request.build(), options);
            if (res == null) {
                res = Response.builder().request(req).build();
            }
            response = res;
            if (ws == null) break block14;
            ws.close();
        }
        ResponseWrapper response2 = new ResponseWrapper(request, res, error);
        this.handler.handleReceive((HttpClientResponse)response2, span);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handled receive of " + span));
        }
        return response;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    ResponseWrapper response3 = new ResponseWrapper(request, res, error);
                    this.handler.handleReceive((HttpClientResponse)response3, span);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of " + span));
                    }
                    throw throwable3;
                }
            }
        }
    }

    void handleSendAndReceive(Span span, Request req, @Nullable Response res, @Nullable Throwable error) {
        RequestWrapper request = new RequestWrapper(req);
        this.handler.handleSend((HttpClientRequest)request, span.context());
        ResponseWrapper response = res != null ? new ResponseWrapper(request, res, error) : null;
        this.handler.handleReceive((HttpClientResponse)response, span);
    }

    static final class RequestWrapper
    implements HttpClientRequest {
        final Request delegate;
        Map<String, Collection<String>> headers;

        RequestWrapper(Request delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.headers().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.httpMethod().name();
        }

        public String path() {
            String url = this.url();
            if (url == null) {
                return null;
            }
            return URI.create(url).getPath();
        }

        public String url() {
            return this.delegate.url();
        }

        public String header(String name) {
            Collection result = (Collection)this.delegate.headers().get(name);
            return result != null && result.iterator().hasNext() ? (String)result.iterator().next() : null;
        }

        public void header(String name, String value) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, Collection<String>>(this.delegate.headers());
            }
            if (!this.headers.containsKey(name)) {
                this.headers.put(name, Collections.singletonList(value));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Added key [" + name + "] and header value [" + value + "]"));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Key [" + name + "] already there in the headers"));
            }
        }

        Request build() {
            if (this.headers == null) {
                return this.delegate;
            }
            String url = this.delegate.url();
            byte[] body = this.delegate.body();
            Charset charset = this.delegate.charset();
            return Request.create((Request.HttpMethod)this.delegate.httpMethod(), (String)url, this.headers, (byte[])body, (Charset)charset, (RequestTemplate)this.delegate.requestTemplate());
        }
    }

    static final class ResponseWrapper
    implements HttpClientResponse {
        final RequestWrapper request;
        final Response response;
        @Nullable
        final Throwable error;

        ResponseWrapper(RequestWrapper request, @Nullable Response response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public Collection<String> headerNames() {
            return this.response != null ? this.response.headers().keySet() : Collections.emptyList();
        }

        public RequestWrapper request() {
            return this.request;
        }

        @Nullable
        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            if (this.response == null) {
                return 0;
            }
            return this.response.status();
        }

        public String header(String header) {
            if (this.response == null) {
                return null;
            }
            Collection strings = (Collection)this.response.headers().get(header);
            if (strings.isEmpty()) {
                return null;
            }
            return (String)strings.iterator().next();
        }
    }
}

