/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.batch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.batch.SleuthBatchSpan;

class TraceJobExecutionListener
implements JobExecutionListener {
    private final Tracer tracer;
    private static final Map<JobExecution, SpanAndScope> SPANS = new ConcurrentHashMap<JobExecution, SpanAndScope>();

    TraceJobExecutionListener(Tracer tracer) {
        this.tracer = tracer;
    }

    public void beforeJob(JobExecution jobExecution) {
        AssertingSpan span = SleuthBatchSpan.BATCH_JOB_SPAN.wrap(this.tracer.nextSpan()).name(jobExecution.getJobInstance().getJobName());
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span.start());
        SPANS.put(jobExecution, new SpanAndScope((Span)span, spanInScope));
    }

    public void afterJob(JobExecution jobExecution) {
        SpanAndScope spanAndScope = SPANS.remove(jobExecution);
        List throwables = jobExecution.getFailureExceptions();
        AssertingSpan span = SleuthBatchSpan.BATCH_JOB_SPAN.wrap(spanAndScope.getSpan()).tag((TagKey)SleuthBatchSpan.JobTags.JOB_NAME, jobExecution.getJobInstance().getJobName()).tag((TagKey)SleuthBatchSpan.JobTags.JOB_INSTANCE_ID, String.valueOf(jobExecution.getJobInstance().getInstanceId())).tag((TagKey)SleuthBatchSpan.JobTags.JOB_EXECUTION_ID, String.valueOf(jobExecution.getId()));
        Tracer.SpanInScope scope = spanAndScope.getScope();
        if (!throwables.isEmpty()) {
            span.error((Throwable)this.mergedThrowables(throwables));
        }
        span.end();
        scope.close();
    }

    private IllegalStateException mergedThrowables(List<Throwable> throwables) {
        return new IllegalStateException(throwables.stream().map(Throwable::toString).collect(Collectors.joining("\n")));
    }
}

