/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.config;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.config.SleuthConfigSpan;

@Aspect
public class TraceEnvironmentRepositoryAspect {
    private final Tracer tracer;

    public TraceEnvironmentRepositoryAspect(Tracer tracer) {
        this.tracer = tracer;
    }

    /*
     * Loose catch block
     */
    @Around(value="execution (* org.springframework.cloud.config.server.environment.EnvironmentRepository.*(..))")
    public Object traceFindEnvironment(ProceedingJoinPoint pjp) throws Throwable {
        AssertingSpan findOneSpan = SleuthConfigSpan.CONFIG_SPAN.wrap(this.tracer.nextSpan()).name(SleuthConfigSpan.CONFIG_SPAN.getName()).tag((TagKey)SleuthConfigSpan.Tags.ENVIRONMENT_CLASS, pjp.getTarget().getClass().getName()).tag((TagKey)SleuthConfigSpan.Tags.ENVIRONMENT_METHOD, pjp.getSignature().getName());
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpan((Span)findOneSpan.start());){
                Object object = pjp.proceed();
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            findOneSpan.end();
        }
    }
}

