/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.propagation.Propagator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveKafkaTracingPropagator {
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Getter<ConsumerRecord<?, ?>> extractor;

    public ReactiveKafkaTracingPropagator(Tracer tracer, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.extractor = extractor;
    }

    public <K, V, T extends ConsumerRecord<K, V>> Flux<T> propagateSpanContextToReactiveContext(Flux<T> publisher) {
        return publisher.flatMap(consumerRecord -> Mono.deferContextual(contextView -> {
            Span newSpanWithParent = this.propagator.extract(consumerRecord, this.extractor).kind(Span.Kind.CONSUMER).name("kafka.consumer").tag("kafka.topic", consumerRecord.topic()).tag("kafka.offset", Long.toString(consumerRecord.offset())).tag("kafka.partition", Integer.toString(consumerRecord.partition())).start();
            return ReactorSleuth.tracedMono(this.tracer, newSpanWithParent, () -> Mono.just((Object)consumerRecord));
        }));
    }
}

