/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.servlet;

import java.util.Collection;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletRequestWrapper;
import org.springframework.cloud.sleuth.instrument.web.servlet.ServletRuntime;
import org.springframework.lang.Nullable;

public class HttpServletResponseWrapper
implements HttpServerResponse {
    @Nullable
    final HttpServletRequestWrapper request;
    final HttpServletResponse response;
    @Nullable
    final Throwable caught;

    public static HttpServerResponse create(@Nullable HttpServletRequest request, HttpServletResponse response, @Nullable Throwable caught) {
        return new HttpServletResponseWrapper(request, response, caught);
    }

    HttpServletResponseWrapper(@Nullable HttpServletRequest request, HttpServletResponse response, @Nullable Throwable caught) {
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        this.request = request != null ? new HttpServletRequestWrapper(request) : null;
        this.response = response;
        this.caught = caught;
    }

    public final Object unwrap() {
        return this.response;
    }

    public Collection<String> headerNames() {
        return this.response.getHeaderNames();
    }

    @Nullable
    public HttpServletRequestWrapper request() {
        return this.request;
    }

    public Throwable error() {
        if (this.caught != null) {
            return this.caught;
        }
        if (this.request == null) {
            return null;
        }
        return this.request.maybeError();
    }

    public int statusCode() {
        int result = ServletRuntime.get().status(this.response);
        if (this.caught != null && result == 200) {
            if (this.caught instanceof UnavailableException) {
                return ((UnavailableException)this.caught).isPermanent() ? 404 : 503;
            }
            return 500;
        }
        return result;
    }
}

