/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpan;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpans;
import org.springframework.cloud.sleuth.instrument.messaging.TraceMessageHandler;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class TraceFunctionAroundWrapper
extends FunctionAroundWrapper
implements ApplicationListener<RefreshScopeRefreshedEvent> {
    private static final Log log = LogFactory.getLog(TraceFunctionAroundWrapper.class);
    private final Environment environment;
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Setter<MessageHeaderAccessor> injector;
    private final Propagator.Getter<MessageHeaderAccessor> extractor;
    final Map<String, String> functionToDestinationCache = new ConcurrentHashMap<String, String>();

    public TraceFunctionAroundWrapper(Environment environment, Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor) {
        this.environment = environment;
        this.tracer = tracer;
        this.propagator = propagator;
        this.injector = injector;
        this.extractor = extractor;
    }

    protected Object doApply(Message<byte[]> message, SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction) {
        Object result;
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(this.tracer, this.propagator, this.injector, this.extractor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will retrieve the tracing headers from the message");
        }
        MessageAndSpans wrappedInputMessage = traceMessageHandler.wrapInputMessage(message, this.inputDestination(targetFunction.getFunctionDefinition()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapped input msg " + wrappedInputMessage));
        }
        Exception throwable = null;
        try (Tracer.SpanInScope ws = this.tracer.withSpan(wrappedInputMessage.childSpan.start());){
            result = targetFunction.apply((Object)wrappedInputMessage.msg);
        }
        catch (Exception e) {
            throwable = e;
            throw e;
        }
        finally {
            traceMessageHandler.afterMessageHandled(wrappedInputMessage.childSpan, throwable);
        }
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returned message is null - we have a consumer");
            }
            return null;
        }
        Message msgResult = this.toMessage(result);
        MessageAndSpan wrappedOutputMessage = traceMessageHandler.wrapOutputMessage(msgResult, wrappedInputMessage.parentSpan, this.outputDestination(targetFunction.getFunctionDefinition()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapped output msg " + wrappedOutputMessage));
        }
        traceMessageHandler.afterMessageHandled(wrappedOutputMessage.span, null);
        return wrappedOutputMessage.msg;
    }

    private Message toMessage(Object result) {
        if (!(result instanceof Message)) {
            return MessageBuilder.withPayload((Object)result).build();
        }
        return (Message)result;
    }

    String inputDestination(String functionDefinition) {
        return this.functionToDestinationCache.computeIfAbsent(functionDefinition, s -> {
            String bindingMappingProperty = "spring.cloud.stream.function.bindings." + s + "-in-0";
            String bindingProperty = this.environment.containsProperty(bindingMappingProperty) ? this.environment.getProperty(bindingMappingProperty) : s + "-in-0";
            return this.environment.getProperty("spring.cloud.stream.bindings." + bindingProperty + ".destination", s);
        });
    }

    String outputDestination(String functionDefinition) {
        return this.functionToDestinationCache.computeIfAbsent(functionDefinition, s -> {
            String bindingMappingProperty = "spring.cloud.stream.function.bindings." + s + "-out-0";
            String bindingProperty = this.environment.containsProperty(bindingMappingProperty) ? this.environment.getProperty(bindingMappingProperty) : s + "-out-0";
            return this.environment.getProperty("spring.cloud.stream.bindings." + bindingProperty + ".destination", s);
        });
    }

    public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Context refreshed, will reset the cache");
        }
        this.functionToDestinationCache.clear();
    }
}

