/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;

class BraveHttpClientResponse
implements HttpClientResponse {
    final brave.http.HttpClientResponse delegate;

    BraveHttpClientResponse(brave.http.HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public String method() {
        return this.delegate.method();
    }

    public String route() {
        return this.delegate.route();
    }

    public int statusCode() {
        return this.delegate.statusCode();
    }

    public Object unwrap() {
        return this.delegate.unwrap();
    }

    public Collection<String> headerNames() {
        return Collections.emptyList();
    }

    public Span.Kind spanKind() {
        return Span.Kind.valueOf((String)this.delegate.spanKind().name());
    }

    public HttpClientRequest request() {
        brave.http.HttpClientRequest request = this.delegate.request();
        if (request == null) {
            return null;
        }
        return new BraveHttpClientRequest(request);
    }

    public Throwable error() {
        return this.delegate.error();
    }

    static brave.http.HttpClientResponse toBrave(final HttpClientResponse httpClientResponse) {
        if (httpClientResponse == null) {
            return null;
        }
        if (httpClientResponse instanceof BraveHttpClientResponse) {
            return ((BraveHttpClientResponse)httpClientResponse).delegate;
        }
        return new brave.http.HttpClientResponse(){

            public int statusCode() {
                return httpClientResponse.statusCode();
            }

            public Object unwrap() {
                return httpClientResponse.unwrap();
            }

            public brave.http.HttpClientRequest request() {
                return BraveHttpClientRequest.toBrave(httpClientResponse.request());
            }

            public Throwable error() {
                return httpClientResponse.error();
            }

            public String method() {
                return httpClientResponse.method();
            }

            public String route() {
                return httpClientResponse.route();
            }
        };
    }
}

