/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.Objects;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;

class BraveScopedSpan
implements ScopedSpan {
    final brave.ScopedSpan span;

    BraveScopedSpan(brave.ScopedSpan span) {
        this.span = span;
    }

    public boolean isNoop() {
        return this.span.isNoop();
    }

    public TraceContext context() {
        return new BraveTraceContext(this.span.context());
    }

    public ScopedSpan name(String name) {
        return new BraveScopedSpan(this.span.name(name));
    }

    public ScopedSpan tag(String key, String value) {
        return new BraveScopedSpan(this.span.tag(key, value));
    }

    public ScopedSpan event(String value) {
        return new BraveScopedSpan(this.span.annotate(value));
    }

    public ScopedSpan error(Throwable throwable) {
        return new BraveScopedSpan(this.span.error(throwable));
    }

    public void end() {
        this.span.finish();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BraveScopedSpan that = (BraveScopedSpan)o;
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.span);
    }
}

