/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.redis;

import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import java.net.SocketAddress;

enum NoOpTracing implements Tracing,
TraceContextProvider,
TracerProvider
{
    INSTANCE;

    private final Tracing.Endpoint NOOP_ENDPOINT = new Tracing.Endpoint(){};

    public TraceContext getTraceContext() {
        return TraceContext.EMPTY;
    }

    public Tracer getTracer() {
        return NoOpTracer.INSTANCE;
    }

    public TracerProvider getTracerProvider() {
        return this;
    }

    public TraceContextProvider initialTraceContextProvider() {
        return this;
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean includeCommandArgsInSpanTags() {
        return false;
    }

    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        return this.NOOP_ENDPOINT;
    }

    public static class NoOpSpan
    extends Tracer.Span {
        static final NoOpSpan INSTANCE = new NoOpSpan();

        public Tracer.Span start(RedisCommand<?, ?, ?> redisCommand) {
            return this;
        }

        public Tracer.Span name(String name) {
            return this;
        }

        public Tracer.Span annotate(String value) {
            return this;
        }

        public Tracer.Span tag(String key, String value) {
            return this;
        }

        public Tracer.Span error(Throwable throwable) {
            return this;
        }

        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            return this;
        }

        public void finish() {
        }
    }

    static class NoOpTracer
    extends Tracer {
        static final Tracer INSTANCE = new NoOpTracer();

        NoOpTracer() {
        }

        public Tracer.Span nextSpan(TraceContext traceContext) {
            return NoOpSpan.INSTANCE;
        }

        public Tracer.Span nextSpan() {
            return NoOpSpan.INSTANCE;
        }
    }
}

