/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceDecorator;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;

public class TraceDataSourceDecoratorBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(TraceDataSourceDecoratorBeanPostProcessor.class);
    private static final boolean HIKARI_AVAILABLE = ClassUtils.isPresent((String)"com.zaxxer.hikari.HikariDataSource", (ClassLoader)DataSourceNameResolver.class.getClassLoader());
    private ApplicationContext applicationContext;
    private DataSourceNameResolver dataSourceNameResolver;
    private final Collection<String> excludedBeans;

    public TraceDataSourceDecoratorBeanPostProcessor(Collection<String> excludedBeans) {
        this.excludedBeans = excludedBeans;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource && !ScopedProxyUtils.isScopedTarget((String)beanName) && !this.excludedBeans.contains(beanName)) {
            Map decorators = this.applicationContext.getBeansOfType(DataSourceDecorator.class).entrySet().stream().sorted(Map.Entry.comparingByValue(AnnotationAwareOrderComparator.INSTANCE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
            return this.decorate((DataSource)bean, this.getDataSourceName(bean, beanName), decorators);
        }
        return bean;
    }

    private String getDataSourceName(Object bean, String beanName) {
        HikariDataSource hikariDataSource;
        if (HIKARI_AVAILABLE && bean instanceof HikariDataSource && (hikariDataSource = (HikariDataSource)bean).getPoolName() != null && !hikariDataSource.getPoolName().startsWith("HikariPool-")) {
            return hikariDataSource.getPoolName();
        }
        return beanName;
    }

    private DataSource decorate(DataSource dataSource, String name, Map<String, DataSourceDecorator> decorators) {
        this.getDataSourceNameResolver().addDataSource(name, (CommonDataSource)dataSource);
        DataSource decoratedDataSource = dataSource;
        for (Map.Entry<String, DataSourceDecorator> decoratorEntry : decorators.entrySet()) {
            String decoratorBeanName = decoratorEntry.getKey();
            DataSource dataSourceBeforeDecorating = decoratedDataSource;
            DataSourceDecorator decorator = decoratorEntry.getValue();
            if (dataSourceBeforeDecorating == (decoratedDataSource = Objects.requireNonNull(decorator.decorate(name, decoratedDataSource), "DataSourceDecorator (" + decoratorBeanName + ", " + decorator + ") should not return null"))) continue;
            this.getDataSourceNameResolver().addDataSource(name, (CommonDataSource)decoratedDataSource);
        }
        if (dataSource != decoratedDataSource) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The decorated data source [" + decoratedDataSource + "] will replace the original one [" + dataSource + "]"));
            }
            decoratedDataSource = new DataSourceWrapper(dataSource, decoratedDataSource);
            this.getDataSourceNameResolver().addDataSource(name, (CommonDataSource)decoratedDataSource);
        }
        return decoratedDataSource;
    }

    private DataSourceNameResolver getDataSourceNameResolver() {
        if (this.dataSourceNameResolver == null) {
            this.dataSourceNameResolver = (DataSourceNameResolver)this.applicationContext.getBean(DataSourceNameResolver.class);
        }
        return this.dataSourceNameResolver;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

