/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.sleuth.reactor")
public class SleuthReactorProperties {
    private static final Log log = LogFactory.getLog(SleuthReactorProperties.class);
    private boolean enabled = true;
    @Deprecated
    private boolean decorateOnEach = true;
    private InstrumentationType instrumentationType = InstrumentationType.DECORATE_ON_EACH;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated
    public boolean isDecorateOnEach() {
        this.warn();
        return this.instrumentationType == InstrumentationType.DECORATE_ON_EACH;
    }

    @Deprecated
    public void setDecorateOnEach(boolean decorateOnEach) {
        this.warn();
        this.instrumentationType = decorateOnEach ? InstrumentationType.DECORATE_ON_EACH : InstrumentationType.DECORATE_ON_LAST;
    }

    private void warn() {
        log.warn((Object)"You're using the deprecated [spring.sleuth.reactor.decorate-on-each] property. Please use the [spring.sleuth.reactor.instrumentation-type]");
    }

    public InstrumentationType getInstrumentationType() {
        return this.instrumentationType;
    }

    public void setInstrumentationType(InstrumentationType instrumentationType) {
        this.instrumentationType = instrumentationType;
    }

    public static enum InstrumentationType {
        DECORATE_ON_EACH,
        DECORATE_ON_LAST,
        MANUAL;

    }
}

