/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.skipper.client.DefaultSkipperClient;
import org.springframework.cloud.skipper.domain.AboutResource;
import org.springframework.cloud.skipper.domain.CancelRequest;
import org.springframework.cloud.skipper.domain.CancelResponse;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.Info;
import org.springframework.cloud.skipper.domain.InstallRequest;
import org.springframework.cloud.skipper.domain.LogInfo;
import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.springframework.cloud.skipper.domain.Release;
import org.springframework.cloud.skipper.domain.Repository;
import org.springframework.cloud.skipper.domain.RollbackRequest;
import org.springframework.cloud.skipper.domain.ScaleRequest;
import org.springframework.cloud.skipper.domain.Template;
import org.springframework.cloud.skipper.domain.UpgradeRequest;
import org.springframework.cloud.skipper.domain.UploadRequest;

public interface SkipperClient {
    public static SkipperClient create(String baseUrl) {
        return new DefaultSkipperClient(baseUrl);
    }

    public Template getSpringCloudDeployerApplicationTemplate();

    public AboutResource info();

    public Collection<PackageMetadata> search(String var1, boolean var2);

    public Release install(InstallRequest var1);

    public Release upgrade(UpgradeRequest var1);

    public PackageMetadata upload(UploadRequest var1);

    public void packageDelete(String var1);

    public void delete(String var1, boolean var2);

    public Release rollback(RollbackRequest var1);

    @Deprecated
    public Release rollback(String var1, int var2);

    public CancelResponse cancel(CancelRequest var1);

    public List<Release> list(String var1);

    public Collection<Release> history(String var1);

    public Collection<Repository> listRepositories();

    public Collection<Deployer> listDeployers();

    public Info status(String var1);

    public Map<String, Info> statuses(String ... var1);

    public Map<String, Map<String, DeploymentState>> states(String ... var1);

    public Info status(String var1, int var2);

    public String manifest(String var1);

    public String manifest(String var1, int var2);

    public LogInfo getLog(String var1);

    public LogInfo getLog(String var1, String var2);

    public Release scale(String var1, ScaleRequest var2);
}

