/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.skipper.client.DefaultSkipperClient;
import org.springframework.cloud.skipper.client.SkipperClient;
import org.springframework.cloud.skipper.client.SkipperClientProperties;
import org.springframework.cloud.skipper.client.SkipperClientResponseErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={SkipperClientProperties.class})
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class SkipperClientConfiguration {
    public static final String SKIPPERCLIENT_RESTTEMPLATE_BEAN_NAME = "skipperClientRestTemplate";

    @Bean(name={"skipperClientRestTemplate"})
    public RestTemplate skipperClientRestTemplate(RestTemplateBuilder restTemplateBuilder, ObjectMapper objectMapper) {
        RestTemplate restTemplate = restTemplateBuilder.errorHandler((ResponseErrorHandler)new SkipperClientResponseErrorHandler(objectMapper)).build();
        return this.validateRestTemplate(restTemplate);
    }

    @Bean
    public SkipperClient skipperClient(SkipperClientProperties properties, RestTemplate restTemplate) {
        return new DefaultSkipperClient(properties.getServerUri(), restTemplate);
    }

    public RestTemplate validateRestTemplate(RestTemplate restTemplate) {
        boolean containsMappingJackson2HttpMessageConverter = false;
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            containsMappingJackson2HttpMessageConverter = true;
        }
        if (!containsMappingJackson2HttpMessageConverter) {
            throw new IllegalArgumentException("The RestTemplate does not contain a required MappingJackson2HttpMessageConverter.");
        }
        return restTemplate;
    }
}

