/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.sso;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.oauth2.sso")
public class OAuth2SsoProperties {
    public static final String DEFAULT_LOGIN_PATH = "/login";
    private final String accessTokenUri;
    private String serviceId = "sso";
    private String logoutPath = "/logout";
    private String logoutUri;
    private String loginPath = "/login";
    private Home home = new Home();
    private boolean logoutRedirect;
    private Integer filterOrder;

    public String getLogoutUri(String redirectUrl) {
        return StringUtils.hasText((String)this.logoutUri) ? this.logoutUri : this.accessTokenUri.replace("/oauth/token", "/logout.do?redirect=" + redirectUrl);
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public Home getHome() {
        return this.home;
    }

    public boolean isLogoutRedirect() {
        return this.logoutRedirect;
    }

    public Integer getFilterOrder() {
        return this.filterOrder;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public void setHome(Home home) {
        this.home = home;
    }

    public void setLogoutRedirect(boolean logoutRedirect) {
        this.logoutRedirect = logoutRedirect;
    }

    public void setFilterOrder(Integer filterOrder) {
        this.filterOrder = filterOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SsoProperties)) {
            return false;
        }
        OAuth2SsoProperties other = (OAuth2SsoProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessTokenUri = this.getAccessTokenUri();
        String other$accessTokenUri = other.getAccessTokenUri();
        if (this$accessTokenUri == null ? other$accessTokenUri != null : !this$accessTokenUri.equals(other$accessTokenUri)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$logoutPath = this.getLogoutPath();
        String other$logoutPath = other.getLogoutPath();
        if (this$logoutPath == null ? other$logoutPath != null : !this$logoutPath.equals(other$logoutPath)) {
            return false;
        }
        String this$logoutUri = this.getLogoutUri();
        String other$logoutUri = other.getLogoutUri();
        if (this$logoutUri == null ? other$logoutUri != null : !this$logoutUri.equals(other$logoutUri)) {
            return false;
        }
        String this$loginPath = this.getLoginPath();
        String other$loginPath = other.getLoginPath();
        if (this$loginPath == null ? other$loginPath != null : !this$loginPath.equals(other$loginPath)) {
            return false;
        }
        Home this$home = this.getHome();
        Home other$home = other.getHome();
        if (this$home == null ? other$home != null : !((Object)this$home).equals(other$home)) {
            return false;
        }
        if (this.isLogoutRedirect() != other.isLogoutRedirect()) {
            return false;
        }
        Integer this$filterOrder = this.getFilterOrder();
        Integer other$filterOrder = other.getFilterOrder();
        return !(this$filterOrder == null ? other$filterOrder != null : !((Object)this$filterOrder).equals(other$filterOrder));
    }

    public boolean canEqual(Object other) {
        return other instanceof OAuth2SsoProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessTokenUri = this.getAccessTokenUri();
        result = result * 59 + ($accessTokenUri == null ? 0 : $accessTokenUri.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 0 : $serviceId.hashCode());
        String $logoutPath = this.getLogoutPath();
        result = result * 59 + ($logoutPath == null ? 0 : $logoutPath.hashCode());
        String $logoutUri = this.getLogoutUri();
        result = result * 59 + ($logoutUri == null ? 0 : $logoutUri.hashCode());
        String $loginPath = this.getLoginPath();
        result = result * 59 + ($loginPath == null ? 0 : $loginPath.hashCode());
        Home $home = this.getHome();
        result = result * 59 + ($home == null ? 0 : ((Object)$home).hashCode());
        result = result * 59 + (this.isLogoutRedirect() ? 79 : 97);
        Integer $filterOrder = this.getFilterOrder();
        result = result * 59 + ($filterOrder == null ? 0 : ((Object)$filterOrder).hashCode());
        return result;
    }

    public String toString() {
        return "OAuth2SsoProperties(accessTokenUri=" + this.getAccessTokenUri() + ", serviceId=" + this.getServiceId() + ", logoutPath=" + this.getLogoutPath() + ", logoutUri=" + this.getLogoutUri() + ", loginPath=" + this.getLoginPath() + ", home=" + this.getHome() + ", logoutRedirect=" + this.isLogoutRedirect() + ", filterOrder=" + this.getFilterOrder() + ")";
    }

    @ConstructorProperties(value={"accessTokenUri"})
    @Autowired
    public OAuth2SsoProperties(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public static class Home {
        private String[] path = new String[]{"/"};
        private boolean secure = true;

        public String getRoot() {
            String result;
            String string = result = this.path != null && this.path.length > 0 ? this.path[0] : "/";
            if (result.contains("*")) {
                result = result.substring(0, result.indexOf("*"));
                result = result.substring(0, result.lastIndexOf("/") + 1);
            }
            return result;
        }

        public String[] getPath() {
            return this.path;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setPath(String[] path) {
            this.path = path;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Home)) {
                return false;
            }
            Home other = (Home)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPath(), other.getPath())) {
                return false;
            }
            return this.isSecure() == other.isSecure();
        }

        public boolean canEqual(Object other) {
            return other instanceof Home;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getPath());
            result = result * 59 + (this.isSecure() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OAuth2SsoProperties.Home(path=" + Arrays.deepToString(this.getPath()) + ", secure=" + this.isSecure() + ")";
        }
    }
}

