/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.security.oauth2.resource.ResourceServerProperties;
import org.springframework.cloud.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={ResourceServerCondition.class})
@ConditionalOnClass(value={EnableResourceServer.class, SecurityProperties.class})
@ConditionalOnWebApplication
@EnableResourceServer
@Import(value={ResourceServerTokenServicesConfiguration.class})
public class OAuth2ResourceConfiguration {
    @Autowired
    private ResourceServerProperties resource;

    @Bean
    @ConditionalOnMissingBean(value={ResourceServerConfigurer.class})
    public ResourceServerConfigurer resourceServer() {
        return new ResourceSecurityConfigurer(this.resource);
    }

    protected static class ResourceServerCondition
    extends SpringBootCondition {
        protected ResourceServerCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
            String client = environment.resolvePlaceholders("${spring.oauth2.client.clientId:}");
            if (StringUtils.hasText((String)client)) {
                return ConditionOutcome.match((String)"found client id");
            }
            if (!resolver.getSubProperties("spring.oauth2.resource.jwt").isEmpty()) {
                return ConditionOutcome.match((String)"found JWT resource configuration");
            }
            if (!resolver.getSubProperties("spring.oauth2.resource.userInfoUri").isEmpty()) {
                return ConditionOutcome.match((String)"found UserInfo URI resource configuration");
            }
            return ConditionOutcome.noMatch((String)"found neither client id nor JWT resource");
        }
    }

    @Configuration
    protected static class ResourceServerOrderProcessor
    implements BeanPostProcessor {
        protected ResourceServerOrderProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ResourceServerConfiguration) {
                ResourceServerConfiguration configuration = (ResourceServerConfiguration)bean;
                configuration.setOrder(this.getOrder());
            }
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        private int getOrder() {
            if (ClassUtils.isPresent((String)"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties", null)) {
                return 2147483626;
            }
            return 0x7FFFFFEE;
        }
    }

    protected static class ResourceSecurityConfigurer
    extends ResourceServerConfigurerAdapter {
        private ResourceServerProperties resource;

        @Autowired
        public ResourceSecurityConfigurer(ResourceServerProperties resource) {
            this.resource = resource;
        }

        public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
            resources.resourceId(this.resource.getResourceId());
        }

        public void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
    }
}

