/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.security.oauth2.client.OAuth2ClientAutoConfiguration;
import org.springframework.cloud.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

@Configuration
@ConditionalOnClass(value={LoadBalancerInterceptor.class, OAuth2RestTemplate.class})
@ConditionalOnBean(value={LoadBalancerInterceptor.class})
@AutoConfigureAfter(value={OAuth2ClientAutoConfiguration.class})
public class OAuth2LoadBalancerClientAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"spring.oauth2.resource.loadBalanced"}, matchIfMissing=false)
    protected static class UserInfoLoadBalancerConfig {
        protected UserInfoLoadBalancerConfig() {
        }

        @Bean
        public UserInfoRestTemplateCustomizer loadBalancedUserInfoRestTemplateCustomizer(final LoadBalancerInterceptor loadBalancerInterceptor) {
            return new UserInfoRestTemplateCustomizer(){

                @Override
                public void customize(OAuth2RestTemplate restTemplate) {
                    ArrayList<LoadBalancerInterceptor> interceptors = new ArrayList<LoadBalancerInterceptor>(restTemplate.getInterceptors());
                    interceptors.add(loadBalancerInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
            };
        }
    }

    @Configuration
    @ConditionalOnBean(value={OAuth2ClientContext.class})
    protected static class LoadBalancedOauth2RestTemplateConfig {
        protected LoadBalancedOauth2RestTemplateConfig() {
        }

        @Bean
        @LoadBalanced
        public OAuth2RestTemplate loadBalancedOauth2RestTemplate(LoadBalancerInterceptor loadBalancerInterceptor, OAuth2ClientContext oauth2ClientContext, OAuth2ProtectedResourceDetails details) {
            OAuth2RestTemplate restTemplate = new OAuth2RestTemplate(details, oauth2ClientContext);
            ArrayList<LoadBalancerInterceptor> interceptors = new ArrayList<LoadBalancerInterceptor>(restTemplate.getInterceptors());
            interceptors.add(loadBalancerInterceptor);
            restTemplate.setInterceptors(interceptors);
            return restTemplate;
        }
    }
}

