/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.security.oauth2.sso.OAuth2SsoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;

@Configuration
@ConditionalOnClass(value={OAuth2ClientContext.class})
@ConditionalOnExpression(value="'${spring.oauth2.client.clientId:}'!=''")
@EnableConfigurationProperties
public class OAuth2ClientAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={OAuth2SsoConfiguration.class})
    @ConditionalOnWebApplication
    protected static class RequestScopedConfiguration
    extends BaseConfiguration {
        protected RequestScopedConfiguration() {
        }

        @Bean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public OAuth2ClientContext oauth2ClientContext() {
            OAuth2Authentication authentication;
            Object details;
            DefaultOAuth2ClientContext context = new DefaultOAuth2ClientContext(this.accessTokenRequest);
            Authentication principal = SecurityContextHolder.getContext().getAuthentication();
            if (principal instanceof OAuth2Authentication && (details = (authentication = (OAuth2Authentication)principal).getDetails()) instanceof OAuth2AuthenticationDetails) {
                OAuth2AuthenticationDetails oauthsDetails = (OAuth2AuthenticationDetails)details;
                String token = oauthsDetails.getTokenValue();
                context.setAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            }
            return context;
        }
    }

    @Configuration
    @ConditionalOnBean(value={OAuth2SsoConfiguration.class})
    @ConditionalOnWebApplication
    protected static class SessionScopedConfiguration
    extends BaseConfiguration {
        protected SessionScopedConfiguration() {
        }

        @Bean
        @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
        public OAuth2ClientContext oauth2ClientContext() {
            return new DefaultOAuth2ClientContext(this.accessTokenRequest);
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    protected static class SingletonScopedConfiguration {
        protected SingletonScopedConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="spring.oauth2.client")
        @Primary
        public ClientCredentialsResourceDetails oauth2RemoteResource() {
            ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
            return details;
        }

        @Bean
        public OAuth2ClientContext oauth2ClientContext() {
            return new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
        }
    }

    @Configuration
    @EnableOAuth2Client
    protected static abstract class BaseConfiguration {
        @Resource
        @Qualifier(value="accessTokenRequest")
        protected AccessTokenRequest accessTokenRequest;

        protected BaseConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="spring.oauth2.client")
        @Primary
        public AuthorizationCodeResourceDetails oauth2RemoteResource() {
            AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
            return details;
        }

        @Bean
        public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)filter);
            registration.setOrder(-100);
            return registration;
        }
    }

    @Configuration
    protected static class OAuth2RestTemplateConfiguration {
        protected OAuth2RestTemplateConfiguration() {
        }

        @Bean
        @Primary
        public OAuth2RestTemplate oauth2RestTemplate(OAuth2ClientContext oauth2ClientContext, OAuth2ProtectedResourceDetails details) {
            OAuth2RestTemplate template = new OAuth2RestTemplate(details, oauth2ClientContext);
            return template;
        }
    }
}

