/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cloud.security.oauth2.resource.JwtAccessTokenConverterConfigurer;
import org.springframework.cloud.security.oauth2.resource.ResourceServerProperties;
import org.springframework.cloud.security.oauth2.resource.SpringSocialTokenServices;
import org.springframework.cloud.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.cloud.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ResourceServerTokenServicesConfiguration {

    private static class NotJwtToken
    extends SpringBootCondition {
        private JwtToken opposite = new JwtToken();

        private NotJwtToken() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionOutcome outcome = this.opposite.getMatchOutcome(context, metadata);
            if (outcome.isMatch()) {
                return ConditionOutcome.noMatch((String)outcome.getMessage());
            }
            return ConditionOutcome.match((String)outcome.getMessage());
        }
    }

    private static class NotTokenInfo
    extends SpringBootCondition {
        private TokenInfo opposite = new TokenInfo();

        private NotTokenInfo() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionOutcome outcome = this.opposite.getMatchOutcome(context, metadata);
            if (outcome.isMatch()) {
                return ConditionOutcome.noMatch((String)outcome.getMessage());
            }
            return ConditionOutcome.match((String)outcome.getMessage());
        }
    }

    private static class JwtToken
    extends SpringBootCondition {
        private JwtToken() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (StringUtils.hasText((String)context.getEnvironment().getProperty("spring.oauth2.resource.jwt.keyValue")) || StringUtils.hasText((String)context.getEnvironment().getProperty("spring.oauth2.resource.jwt.keyUri"))) {
                return ConditionOutcome.match((String)"Public key is provided");
            }
            return ConditionOutcome.noMatch((String)"Public key is not provided");
        }
    }

    private static class TokenInfo
    extends SpringBootCondition {
        private TokenInfo() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean hasUserInfo;
            Environment environment = context.getEnvironment();
            boolean preferTokenInfo = environment.resolvePlaceholders("${spring.oauth2.resource.preferTokenInfo:${OAUTH2_RESOURCE_PREFERTOKENINFO:true}}").equals("true");
            boolean hasTokenInfo = !environment.resolvePlaceholders("${spring.oauth2.resource.tokenInfoUri:}").equals("");
            boolean bl = hasUserInfo = !environment.resolvePlaceholders("${spring.oauth2.resource.userInfoUri:}").equals("");
            if (!hasUserInfo) {
                return ConditionOutcome.match((String)"No user info provided");
            }
            if (hasTokenInfo && preferTokenInfo) {
                return ConditionOutcome.match((String)"Token info endpoint is preferred and user info provided");
            }
            return ConditionOutcome.noMatch((String)"Token info endpoint is not provided");
        }
    }

    @Configuration
    @Conditional(value={JwtToken.class})
    protected static class JwtTokenServicesConfiguration {
        private static final Logger log = LoggerFactory.getLogger(JwtTokenServicesConfiguration.class);
        private RestTemplate keyUriRestTemplate = new RestTemplate();
        @Autowired
        private ResourceServerProperties resource;
        @Autowired(required=false)
        private List<JwtAccessTokenConverterConfigurer> configurers = Collections.emptyList();

        protected JwtTokenServicesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public ResourceServerTokenServices jwtTokenServices() {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(this.jwtTokenStore());
            return services;
        }

        @Bean
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtTokenEnhancer());
        }

        @Bean
        public JwtAccessTokenConverter jwtTokenEnhancer() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            String keyValue = this.resource.getJwt().getKeyValue();
            if (!StringUtils.hasText((String)keyValue)) {
                try {
                    HttpHeaders headers = new HttpHeaders();
                    if (this.resource.getClientId() != null && this.resource.getClientSecret() != null) {
                        byte[] token = Base64.encode((byte[])(this.resource.getClientId() + ":" + this.resource.getClientSecret()).getBytes());
                        headers.add("Authorization", "Basic " + new String(token));
                    }
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    keyValue = (String)((Map)this.keyUriRestTemplate.exchange(this.resource.getJwt().getKeyUri(), HttpMethod.GET, requestEntity, Map.class, new Object[0]).getBody()).get("value");
                }
                catch (ResourceAccessException e) {
                    log.warn("Failed to fetch token key (you may need to refresh when the auth server is back)");
                }
            }
            if (StringUtils.hasText((String)keyValue) && !keyValue.startsWith("-----BEGIN")) {
                converter.setSigningKey(keyValue);
            }
            if (keyValue != null) {
                converter.setVerifierKey(keyValue);
            }
            AnnotationAwareOrderComparator.sort(this.configurers);
            for (JwtAccessTokenConverterConfigurer configurer : this.configurers) {
                configurer.configure(converter);
            }
            return converter;
        }
    }

    @Configuration
    @Conditional(value={NotJwtToken.class})
    protected static class RemoteTokenServicesConfiguration {
        protected RemoteTokenServicesConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingClass(name={"org.springframework.social.connect.support.OAuth2ConnectionFactory"})
        @Conditional(value={NotTokenInfo.class})
        protected static class UserInfoTokenServicesConfiguration {
            @Autowired
            private ResourceServerProperties sso;
            @Autowired(required=false)
            @Qualifier(value="userInfoRestTemplate")
            private OAuth2RestOperations restTemplate;

            protected UserInfoTokenServicesConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setRestTemplate(this.restTemplate);
                return services;
            }
        }

        @Configuration
        @ConditionalOnClass(value={OAuth2ConnectionFactory.class})
        @Conditional(value={NotTokenInfo.class})
        protected static class SocialTokenServicesConfiguration {
            @Autowired
            private ResourceServerProperties sso;
            @Autowired(required=false)
            private OAuth2ConnectionFactory<?> connectionFactory;
            @Autowired(required=false)
            @Qualifier(value="userInfoRestTemplate")
            private OAuth2RestOperations restTemplate;

            protected SocialTokenServicesConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={ConnectionFactoryLocator.class})
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public SpringSocialTokenServices socialTokenServices() {
                return new SpringSocialTokenServices(this.connectionFactory, this.sso.getClientId());
            }

            @Bean
            @ConditionalOnMissingBean(value={ConnectionFactoryLocator.class, ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setRestTemplate(this.restTemplate);
                return services;
            }
        }

        @Configuration
        @Conditional(value={TokenInfo.class})
        protected static class TokenInfoServicesConfiguration {
            @Autowired
            private ResourceServerProperties resource;

            protected TokenInfoServicesConfiguration() {
            }

            @Bean
            protected ResourceServerTokenServices remoteTokenServices() {
                RemoteTokenServices services = new RemoteTokenServices();
                services.setCheckTokenEndpointUrl(this.resource.getTokenInfoUri());
                services.setClientId(this.resource.getClientId());
                services.setClientSecret(this.resource.getClientSecret());
                return services;
            }
        }
    }

    @Configuration
    protected static class ResourceServerPropertiesConfiguration {
        @Autowired(required=false)
        private OAuth2ProtectedResourceDetails client;

        protected ResourceServerPropertiesConfiguration() {
        }

        @Bean
        public ResourceServerProperties resourceServerProperties() {
            String clientId = this.client == null ? null : this.client.getClientId();
            String clientSecret = this.client == null ? null : this.client.getClientSecret();
            return new ResourceServerProperties(clientId, clientSecret);
        }
    }

    @Configuration
    protected static class UserInfoRestTemplateConfiguration {
        private static final AuthorizationCodeResourceDetails DEFAULT_RESOURCE_DETAILS = new AuthorizationCodeResourceDetails();
        @Autowired(required=false)
        private List<UserInfoRestTemplateCustomizer> customizers = Collections.emptyList();
        @Autowired(required=false)
        private OAuth2ProtectedResourceDetails details;
        @Autowired(required=false)
        private OAuth2ClientContext oauth2ClientContext;

        protected UserInfoRestTemplateConfiguration() {
        }

        @Bean(name={"userInfoRestTemplate"})
        public OAuth2RestTemplate userInfoRestTemplate() {
            if (this.details == null) {
                this.details = DEFAULT_RESOURCE_DETAILS;
            }
            OAuth2RestTemplate template = this.oauth2ClientContext == null ? new OAuth2RestTemplate(this.details) : new OAuth2RestTemplate(this.details, this.oauth2ClientContext);
            template.setInterceptors(Arrays.asList(new ClientHttpRequestInterceptor(){

                public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                    request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
                    return execution.execute(request, body);
                }
            }));
            AuthorizationCodeAccessTokenProvider accessTokenProvider = new AuthorizationCodeAccessTokenProvider();
            accessTokenProvider.setTokenRequestEnhancer(new RequestEnhancer(){

                public void enhance(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
                    headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
                }
            });
            template.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
            OrderComparator.sort(this.customizers);
            for (UserInfoRestTemplateCustomizer customizer : this.customizers) {
                customizer.customize(template);
            }
            return template;
        }

        static {
            DEFAULT_RESOURCE_DETAILS.setClientId("<N/A>");
            DEFAULT_RESOURCE_DETAILS.setUserAuthorizationUri("Not a URI because there is no client");
            DEFAULT_RESOURCE_DETAILS.setAccessTokenUri("Not a URI because there is no client");
        }
    }
}

