/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(value="spring.oauth2.resource")
public class ResourceServerProperties
implements Validator {
    @JsonIgnore
    private final String clientId;
    @JsonIgnore
    private final String clientSecret;
    private String serviceId = "resource";
    private String id;
    private String userInfoUri;
    private String tokenInfoUri;
    private boolean preferTokenInfo = true;
    private Jwt jwt = new Jwt();

    public String getResourceId() {
        return this.id;
    }

    public boolean supports(Class<?> clazz) {
        return ResourceServerProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ResourceServerProperties resource = (ResourceServerProperties)target;
        if (StringUtils.hasText((String)this.clientId)) {
            if (!StringUtils.hasText((String)this.clientSecret)) {
                if (!StringUtils.hasText((String)resource.getUserInfoUri())) {
                    errors.rejectValue("userInfoUri", "missing.userInfoUri", "Missing userInfoUri (no client secret available)");
                }
            } else if (this.isPreferTokenInfo() && !StringUtils.hasText((String)resource.getTokenInfoUri())) {
                if (StringUtils.hasText((String)this.getJwt().getKeyUri()) || StringUtils.hasText((String)this.getJwt().getKeyValue())) {
                    return;
                }
                if (!StringUtils.hasText((String)resource.getUserInfoUri())) {
                    errors.rejectValue("tokenInfoUri", "missing.tokenInfoUri", "Missing tokenInfoUri and userInfoUri and there is no JWT verifier key");
                }
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getId() {
        return this.id;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public String getTokenInfoUri() {
        return this.tokenInfoUri;
    }

    public boolean isPreferTokenInfo() {
        return this.preferTokenInfo;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public void setTokenInfoUri(String tokenInfoUri) {
        this.tokenInfoUri = tokenInfoUri;
    }

    public void setPreferTokenInfo(boolean preferTokenInfo) {
        this.preferTokenInfo = preferTokenInfo;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceServerProperties)) {
            return false;
        }
        ResourceServerProperties other = (ResourceServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        if (this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri)) {
            return false;
        }
        String this$tokenInfoUri = this.getTokenInfoUri();
        String other$tokenInfoUri = other.getTokenInfoUri();
        if (this$tokenInfoUri == null ? other$tokenInfoUri != null : !this$tokenInfoUri.equals(other$tokenInfoUri)) {
            return false;
        }
        if (this.isPreferTokenInfo() != other.isPreferTokenInfo()) {
            return false;
        }
        Jwt this$jwt = this.getJwt();
        Jwt other$jwt = other.getJwt();
        return !(this$jwt == null ? other$jwt != null : !((Object)this$jwt).equals(other$jwt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 0 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 0 : $clientSecret.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 0 : $serviceId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 0 : $userInfoUri.hashCode());
        String $tokenInfoUri = this.getTokenInfoUri();
        result = result * 59 + ($tokenInfoUri == null ? 0 : $tokenInfoUri.hashCode());
        result = result * 59 + (this.isPreferTokenInfo() ? 79 : 97);
        Jwt $jwt = this.getJwt();
        result = result * 59 + ($jwt == null ? 0 : ((Object)$jwt).hashCode());
        return result;
    }

    public String toString() {
        return "ResourceServerProperties(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", serviceId=" + this.getServiceId() + ", id=" + this.getId() + ", userInfoUri=" + this.getUserInfoUri() + ", tokenInfoUri=" + this.getTokenInfoUri() + ", preferTokenInfo=" + this.isPreferTokenInfo() + ", jwt=" + this.getJwt() + ")";
    }

    @Autowired
    @ConstructorProperties(value={"clientId", "clientSecret"})
    public ResourceServerProperties(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public class Jwt {
        private String keyValue;
        private String keyUri;

        public String getKeyUri() {
            if (this.keyUri != null) {
                return this.keyUri;
            }
            if (ResourceServerProperties.this.userInfoUri != null && ResourceServerProperties.this.userInfoUri.endsWith("/userinfo")) {
                return ResourceServerProperties.this.userInfoUri.replace("/userinfo", "/token_key");
            }
            if (ResourceServerProperties.this.tokenInfoUri != null && ResourceServerProperties.this.tokenInfoUri.endsWith("/check_token")) {
                return ResourceServerProperties.this.userInfoUri.replace("/check_token", "/token_key");
            }
            return null;
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public void setKeyUri(String keyUri) {
            this.keyUri = keyUri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jwt)) {
                return false;
            }
            Jwt other = (Jwt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$keyValue = this.getKeyValue();
            String other$keyValue = other.getKeyValue();
            if (this$keyValue == null ? other$keyValue != null : !this$keyValue.equals(other$keyValue)) {
                return false;
            }
            String this$keyUri = this.getKeyUri();
            String other$keyUri = other.getKeyUri();
            return !(this$keyUri == null ? other$keyUri != null : !this$keyUri.equals(other$keyUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Jwt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $keyValue = this.getKeyValue();
            result = result * 59 + ($keyValue == null ? 0 : $keyValue.hashCode());
            String $keyUri = this.getKeyUri();
            result = result * 59 + ($keyUri == null ? 0 : $keyUri.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceServerProperties.Jwt(keyValue=" + this.getKeyValue() + ", keyUri=" + this.getKeyUri() + ")";
        }
    }
}

