/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public abstract class AbstractBackwardCompatibilityEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private final Log logger = LogFactory.getLog(AbstractBackwardCompatibilityEnvironmentPostProcessor.class);
    private final String propertyKeyName;

    public AbstractBackwardCompatibilityEnvironmentPostProcessor(String propertyKeyName) {
        this.propertyKeyName = propertyKeyName;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : this.doGetPropertyMappings().entrySet()) {
            if (!environment.containsProperty(e.getKey())) continue;
            properties.setProperty(e.getValue(), environment.getProperty(e.getKey()));
        }
        if (!CollectionUtils.isEmpty((Map)properties)) {
            this.logger.info((Object)" 'spring.cloud.stream.schemaXXX' property prefix detected! Use the 'spring.schemaXXX' prefix instead!");
            PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource(this.propertyKeyName, properties);
            environment.getPropertySources().addLast((PropertySource)propertiesPropertySource);
        }
    }

    protected abstract Map<String, String> doGetPropertyMappings();
}

