/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.schema.registry.SchemaReference;
import org.springframework.cloud.schema.registry.SchemaRegistrationResponse;
import org.springframework.cloud.schema.registry.client.SchemaRegistryClient;
import org.springframework.util.Assert;

public class CachingRegistryClient
implements SchemaRegistryClient {
    private static final String CACHE_PREFIX = "org.springframework.cloud.schema.registry.client";
    private static final String ID_CACHE = "org.springframework.cloud.schema.registry.client.schemaByIdCache";
    private static final String REF_CACHE = "org.springframework.cloud.schema.registry.client.schemaByReferenceCache";
    private SchemaRegistryClient delegate;
    @Autowired
    private CacheManager cacheManager;

    public CachingRegistryClient(SchemaRegistryClient delegate) {
        Assert.notNull((Object)delegate, (String)"The delegate cannot be null");
        this.delegate = delegate;
    }

    @Override
    public SchemaRegistrationResponse register(String subject, String format, String schema) {
        SchemaRegistrationResponse response = this.delegate.register(subject, format, schema);
        this.cacheManager.getCache(ID_CACHE).put((Object)response.getId(), (Object)schema);
        this.cacheManager.getCache(REF_CACHE).put((Object)response.getSchemaReference(), (Object)schema);
        return response;
    }

    @Override
    @Cacheable(cacheNames={"org.springframework.cloud.schema.registry.client.schemaByReferenceCache"})
    public String fetch(SchemaReference schemaReference) {
        return this.delegate.fetch(schemaReference);
    }

    @Override
    @Cacheable(cacheNames={"org.springframework.cloud.schema.registry.client.schemaByIdCache"})
    public String fetch(int id) {
        return this.delegate.fetch(id);
    }
}

