/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.reactive;

import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class RequestIdentityWebFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestIdentity = exchange.getRequest().getHeaders().getFirst("X-Broker-API-Request-Identity");
        if (StringUtils.hasLength((String)requestIdentity)) {
            exchange.getResponse().getHeaders().add("X-Broker-API-Request-Identity", requestIdentity);
        }
        return chain.filter(exchange);
    }
}

