/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.servicebroker.autoconfigure.web.Cost;
import org.springframework.util.CollectionUtils;

public class PlanMetadata {
    private static final String COSTS_KEY = "costs";
    private static final String BULLETS_KEY = "bullets";
    private static final String DISPLAYNAME_KEY = "displayName";
    @NestedConfigurationProperty
    @Valid
    private final List<Cost> costs = new ArrayList<Cost>();
    private final List<String> bullets = new ArrayList<String>();
    private String displayName;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public List<Cost> getCosts() {
        return this.costs;
    }

    public void setCosts(List<Cost> costs) {
        if (!CollectionUtils.isEmpty(costs)) {
            this.costs.clear();
            this.costs.addAll(costs);
        }
    }

    public List<String> getBullets() {
        return this.bullets;
    }

    public void setBullets(List<String> bullets) {
        if (!CollectionUtils.isEmpty(bullets)) {
            this.bullets.clear();
            this.bullets.addAll(bullets);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (!CollectionUtils.isEmpty(properties)) {
            this.properties.putAll(properties);
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> toModel() {
        List modelCosts = this.costs.stream().map(Cost::toModel).collect(Collectors.toList());
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(modelCosts)) {
            model.put(COSTS_KEY, modelCosts);
        }
        if (!CollectionUtils.isEmpty(this.bullets)) {
            model.put(BULLETS_KEY, this.bullets);
        }
        if (this.displayName != null) {
            model.put(DISPLAYNAME_KEY, this.displayName);
        }
        if (!CollectionUtils.isEmpty(this.properties)) {
            model.putAll(this.properties);
        }
        return model;
    }
}

