/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.reactive;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.cloud.servicebroker.exception.ServiceBrokerApiVersionErrorMessage;
import org.springframework.cloud.servicebroker.model.BrokerApiVersion;
import org.springframework.cloud.servicebroker.model.error.ErrorMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ApiVersionWebFilter
implements WebFilter {
    private static final String V2_API_PATH_PATTERN = "/v2/**";
    private final BrokerApiVersion version;

    public ApiVersionWebFilter() {
        this(null);
    }

    public ApiVersionWebFilter(BrokerApiVersion version) {
        this.version = version;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        PathPattern pathPattern = new PathPatternParser().parse(V2_API_PATH_PATTERN);
        if (pathPattern.matches((PathContainer)exchange.getRequest().getPath()) && this.version != null && !this.anyVersionAllowed()) {
            String requestedApiVersion = exchange.getRequest().getHeaders().getFirst(this.version.getBrokerApiVersionHeader());
            ServerHttpResponse response = exchange.getResponse();
            if (requestedApiVersion == null) {
                response.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
                return this.writeResponse(response, requestedApiVersion);
            }
            if (!this.version.getApiVersion().equals(requestedApiVersion)) {
                response.setStatusCode((HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
                return this.writeResponse(response, requestedApiVersion);
            }
        }
        return chain.filter(exchange);
    }

    private boolean anyVersionAllowed() {
        return "*".equals(this.version.getApiVersion());
    }

    private Mono<Void> writeResponse(ServerHttpResponse response, String requestedApiVersion) {
        String message = ServiceBrokerApiVersionErrorMessage.from((String)this.version.getApiVersion(), (String)requestedApiVersion).toString();
        return response.writeWith((Publisher)Flux.just((Object)response.bufferFactory().allocateBuffer(256).write((CharSequence)this.toJson(ErrorMessage.builder().message(message).build()), StandardCharsets.UTF_8)));
    }

    private String toJson(ErrorMessage message) {
        String json;
        try {
            json = new ObjectMapper().writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            json = "{}";
        }
        return json;
    }
}

