/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerProperties;
import org.springframework.cloud.servicebroker.model.catalog.Catalog;
import org.springframework.cloud.servicebroker.service.BeanCatalogService;
import org.springframework.cloud.servicebroker.service.CatalogService;
import org.springframework.cloud.servicebroker.service.NonBindableServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.events.EventFlowRegistries;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServiceBrokerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CatalogService.class})
    public CatalogService beanCatalogService(Catalog catalog) {
        return new BeanCatalogService(catalog);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceBindingService.class})
    public ServiceInstanceBindingService nonBindableServiceInstanceBindingService() {
        return new NonBindableServiceInstanceBindingService();
    }

    @Bean
    public EventFlowRegistries eventFlowRegistries() {
        return new EventFlowRegistries();
    }

    @Configuration
    @ConditionalOnMissingBean(value={Catalog.class, CatalogService.class})
    @EnableConfigurationProperties(value={ServiceBrokerProperties.class})
    @ConditionalOnProperty(prefix="spring.cloud.openservicebroker.catalog.services[0]", name={"id"})
    protected static class CatalogPropertiesMinimalConfiguration {
        private final ServiceBrokerProperties serviceBrokerProperties;

        public CatalogPropertiesMinimalConfiguration(ServiceBrokerProperties serviceBrokerProperties) {
            this.serviceBrokerProperties = serviceBrokerProperties;
        }

        @Bean
        public Catalog catalog() {
            return this.serviceBrokerProperties.getCatalog().toModel();
        }
    }
}

