/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerAutoConfiguration;
import org.springframework.cloud.servicebroker.controller.CatalogController;
import org.springframework.cloud.servicebroker.controller.ServiceBrokerExceptionHandler;
import org.springframework.cloud.servicebroker.controller.ServiceInstanceBindingController;
import org.springframework.cloud.servicebroker.controller.ServiceInstanceController;
import org.springframework.cloud.servicebroker.service.CatalogService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={CatalogService.class, ServiceInstanceService.class, ServiceInstanceBindingService.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, ServiceBrokerAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServiceBrokerWebMvcAutoConfiguration {
    private final CatalogService catalogService;
    private final ServiceInstanceService serviceInstanceService;
    private final ServiceInstanceBindingService serviceInstanceBindingService;

    protected ServiceBrokerWebMvcAutoConfiguration(CatalogService catalogService, ServiceInstanceService serviceInstanceService, ServiceInstanceBindingService serviceInstanceBindingService) {
        this.catalogService = catalogService;
        this.serviceInstanceService = serviceInstanceService;
        this.serviceInstanceBindingService = serviceInstanceBindingService;
    }

    @Bean
    public CatalogController catalogController() {
        return new CatalogController(this.catalogService);
    }

    @Bean
    public ServiceInstanceController serviceInstanceController() {
        return new ServiceInstanceController(this.catalogService, this.serviceInstanceService);
    }

    @Bean
    public ServiceInstanceBindingController serviceInstanceBindingController() {
        return new ServiceInstanceBindingController(this.catalogService, this.serviceInstanceBindingService);
    }

    @Bean
    public ServiceBrokerExceptionHandler serviceBrokerExceptionHandler() {
        return new ServiceBrokerExceptionHandler();
    }
}

