/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.servicebroker.autoconfigure.web.ApiVersionInterceptor;
import org.springframework.cloud.servicebroker.autoconfigure.web.ApiVersionWebMvcConfigurerAdapter;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerProperties;
import org.springframework.cloud.servicebroker.model.BrokerApiVersion;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={ServiceInstanceService.class})
@ConditionalOnProperty(prefix="spring.cloud.openservicebroker", name={"apiVersionCheckEnabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={ServiceBrokerProperties.class})
public class ApiVersionWebMvcAutoConfiguration {
    private ServiceBrokerProperties serviceBrokerProperties;

    public ApiVersionWebMvcAutoConfiguration(ServiceBrokerProperties serviceBrokerProperties) {
        this.serviceBrokerProperties = serviceBrokerProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={BrokerApiVersion.class})
    @ConditionalOnProperty(prefix="spring.cloud.openservicebroker", name={"apiVersion"})
    public BrokerApiVersion serviceBrokerApiVersionProperty() {
        return new BrokerApiVersion(this.serviceBrokerProperties.getApiVersion());
    }

    @Bean
    @ConditionalOnMissingBean(value={BrokerApiVersion.class})
    public BrokerApiVersion serviceBrokerApiVersion() {
        return new BrokerApiVersion();
    }

    @Bean
    public ApiVersionInterceptor serviceBrokerApiVersionInterceptor(BrokerApiVersion brokerApiVersion) {
        return new ApiVersionInterceptor(brokerApiVersion);
    }

    @Bean
    public ApiVersionWebMvcConfigurerAdapter serviceBrokerWebMvcConfigurerAdapter(ApiVersionInterceptor apiVersionInterceptor) {
        return new ApiVersionWebMvcConfigurerAdapter(apiVersionInterceptor);
    }
}

