/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.stream;

import java.util.Map;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.turbine.stream.TurbineController;
import org.springframework.cloud.netflix.turbine.stream.TurbineStreamProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rx.subjects.PublishSubject;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TurbineStreamProperties.class})
public class TurbineStreamConfiguration {
    @Bean
    public HasFeatures Feature() {
        return HasFeatures.namedFeature((String)"Turbine (Stream)", TurbineStreamProperties.class);
    }

    @Bean
    public PublishSubject<Map<String, Object>> hystrixSubject() {
        return PublishSubject.create();
    }

    @Bean
    public TurbineController turbineController(PublishSubject<Map<String, Object>> hystrixSubject) {
        return new TurbineController(hystrixSubject);
    }
}

