/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.netflix.sidecar.SidecarProperties;
import org.springframework.web.client.RestTemplate;

public class LocalApplicationHealthIndicator
extends AbstractHealthIndicator {
    @Autowired
    private SidecarProperties properties;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        URI uri = this.properties.getHealthUri();
        if (uri == null) {
            builder.up();
            return;
        }
        Map map = (Map)new RestTemplate().getForObject(uri, Map.class);
        Object status = map.get("status");
        if (status != null && status instanceof String) {
            builder.status(status.toString());
        } else if (status != null && status instanceof Map) {
            Map statusMap = (Map)status;
            Object code = statusMap.get("code");
            if (code != null) {
                builder.status(code.toString());
            } else {
                this.getWarning(builder);
            }
        } else {
            this.getWarning(builder);
        }
    }

    private Health.Builder getWarning(Health.Builder builder) {
        return builder.unknown().withDetail("warning", (Object)"no status field in response");
    }
}

